/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import com.guo.android_extend.GLES2Render;
import com.guo.android_extend.widget.CameraFrameData;
import com.guo.android_extend.widget.ExtGLSurfaceView;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class CameraGLSurfaceView
extends ExtGLSurfaceView
implements GLSurfaceView.Renderer {
    private final String TAG = this.getClass().getSimpleName();
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private int mRenderFormat;
    private int mDegree;
    private int mMirror;
    private boolean mDebugFPS;
    private boolean mConfigSuccess = false;
    private BlockingQueue<CameraFrameData> mImageRenderBuffers;
    private GLES2Render mGLES2Render;
    private OnRenderListener mOnRenderListener;
    private OnDrawListener mOnDrawListener;

    public CameraGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreate();
    }

    public CameraGLSurfaceView(Context context) {
        super(context);
        this.onCreate();
    }

    private void onCreate() {
        if (this.isInEditMode()) {
            return;
        }
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setZOrderMediaOverlay(true);
        this.mImageRenderBuffers = new LinkedBlockingQueue<CameraFrameData>();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.d((String)this.TAG, (String)"onSurfaceCreated");
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log.d((String)this.TAG, (String)"onSurfaceChanged");
        if (this.mGLES2Render == null && this.mConfigSuccess) {
            this.mGLES2Render = new GLES2Render(this.mMirror, this.mDegree, this.mRenderFormat, this.mDebugFPS);
        }
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewPort(width, height);
            this.mGLES2Render.setViewDisplay(this.mMirror, this.mDegree);
        }
    }

    public void onDrawFrame(GL10 gl) {
        CameraFrameData data = (CameraFrameData)this.mImageRenderBuffers.poll();
        if (data != null) {
            byte[] buffer = data.mData;
            if (this.mOnRenderListener != null) {
                this.mOnRenderListener.onBeforeRender(data);
            }
            if (this.mGLES2Render != null) {
                this.mGLES2Render.render(buffer, this.mWidth, this.mHeight);
            }
            if (this.mOnRenderListener != null) {
                this.mOnRenderListener.onAfterRender(data);
            }
        }
        if (this.mOnDrawListener != null) {
            this.mOnDrawListener.onDrawOverlap(this.mGLES2Render);
        }
    }

    public void requestRender(CameraFrameData data) {
        if (!this.mImageRenderBuffers.offer(data)) {
            Log.e((String)this.TAG, (String)"RENDER QUEUE FULL!");
        } else {
            this.requestRender();
        }
    }

    public void setOnDrawListener(OnDrawListener lis) {
        this.mOnDrawListener = lis;
    }

    public void setOnRenderListener(OnRenderListener lis) {
        this.mOnRenderListener = lis;
    }

    public boolean setImageConfig(int width, int height, int format) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        switch (format) {
            case 17: {
                this.mRenderFormat = 2050;
                this.mConfigSuccess = true;
                break;
            }
            case 4: {
                this.mRenderFormat = 4;
                this.mConfigSuccess = true;
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)("Current camera preview format = " + format + ", render is not support!"));
                this.mConfigSuccess = false;
            }
        }
        return this.mConfigSuccess;
    }

    public void setRenderConfig(int degree, int mirror) {
        this.mDegree = degree;
        this.mMirror = mirror;
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewDisplay(this.mMirror, degree);
        }
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewDisplay(this.mMirror, degree);
        }
        return super.OnOrientationChanged(degree, offset, flag);
    }

    public GLES2Render getGLES2Render() {
        return this.mGLES2Render;
    }

    public void debug_print_fps(boolean show) {
        this.mDebugFPS = show;
    }

    public static interface OnRenderListener {
        public void onBeforeRender(CameraFrameData var1);

        public void onAfterRender(CameraFrameData var1);
    }

    public static interface OnDrawListener {
        public void onDrawOverlap(GLES2Render var1);
    }
}

