/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.java.network.socket.Data;

import com.guo.android_extend.java.network.NetWorkFile;
import com.guo.android_extend.java.network.socket.Data.AbsTransmitter;
import com.guo.android_extend.tools.LogcatHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TransmitFile
extends AbsTransmitter {
    private String TAG = this.getClass().getSimpleName();
    NetWorkFile mNetWorkFile;
    String mName;
    byte[] mData;
    int mLength;

    public TransmitFile(String local_dir, String remote_file) {
        super(1894711296);
        this.mNetWorkFile = new NetWorkFile(local_dir, remote_file);
        this.mName = null;
        this.mLength = 0;
    }

    public TransmitFile(String local_file) {
        super(1894711296);
        this.mNetWorkFile = new NetWorkFile(null, local_file);
        this.mName = local_file;
        long max = new File(this.mName).length();
        if (max > Integer.MAX_VALUE) {
            throw new RuntimeException("file size not support!");
        }
        this.mLength = (int)max;
        this.mData = new byte[this.mName.getBytes().length + 10];
        System.arraycopy(TransmitFile.int_to_bytes_big(this.getType()), 0, this.mData, 0, 4);
        System.arraycopy(TransmitFile.short_to_bytes_big((short)this.mName.getBytes().length), 0, this.mData, 4, 2);
        System.arraycopy(this.mName.getBytes(), 0, this.mData, 6, this.mName.getBytes().length);
        System.arraycopy(TransmitFile.int_to_bytes_big(this.mLength), 0, this.mData, this.mName.getBytes().length + 6, 4);
    }

    @Override
    public int send(DataOutputStream stream, byte[] mBuffer) {
        int ret = 0;
        DataInputStream input = this.getDataInputStream();
        if (input == null) {
            LogcatHelper.e("TransmitInterface", "loop: Bad object!");
            return 6;
        }
        try {
            stream.write(this.mData);
            int read = 0;
            for (int size = 0; size < this.mLength; size += read) {
                read = input.read(mBuffer);
                stream.write(mBuffer, 0, read);
                if (this.mOnSenderListener == null) continue;
                this.mOnSenderListener.onSendProcess(this, size + read, this.mLength);
            }
            stream.write(TransmitFile.int_to_bytes_big(-354680832));
            stream.flush();
        }
        catch (Exception e) {
            LogcatHelper.e("TransmitInterface", "loop:" + e.getMessage());
            ret = 4;
        }
        try {
            input.close();
        }
        catch (IOException e) {
            LogcatHelper.e("TransmitInterface", "loop:" + e.getMessage());
            ret = 7;
        }
        return ret;
    }

    @Override
    public int recv(DataInputStream stream, byte[] mBuffer) {
        block5: {
            try {
                String name = stream.readUTF();
                this.mNetWorkFile.setUrl(name);
                this.mName = this.mNetWorkFile.getLocalFile();
                int length = stream.readInt();
                DataOutputStream output = this.getDataOutputStream();
                int read = 0;
                for (int size = 0; size < length; size += read) {
                    read = stream.read(mBuffer, 0, Math.min(length - size, mBuffer.length));
                    output.write(mBuffer, 0, read);
                    if (this.mOnReceiverListener == null) continue;
                    this.mOnReceiverListener.onReceiveProcess(this, size, length);
                }
                if (stream.readInt() != -354680832) {
                    throw new Exception("received end code error!");
                }
                output.flush();
                output.close();
                if (this.mOnReceiverListener != null) {
                    this.mOnReceiverListener.onReceiveProcess(this, length, length);
                }
            }
            catch (Exception e) {
                LogcatHelper.e("", "loop:" + e.getMessage());
                if (this.mOnReceiverListener == null) break block5;
                this.mOnReceiverListener.onException(7);
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public DataInputStream getDataInputStream() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(this.mName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return new DataInputStream(new BufferedInputStream(fis));
    }

    @Override
    public DataOutputStream getDataOutputStream() {
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(new File(this.mName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return new DataOutputStream(new BufferedOutputStream(fis));
    }
}

