/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.effective;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Scroller;
import com.guo.android_extend.R;
import com.guo.android_extend.widget.effective.HCSGestureDetector;
import java.util.LinkedList;
import java.util.Queue;

public class HCSListView
extends AdapterView<ListAdapter> {
    private final String TAG = ((Object)((Object)this)).getClass().toString();
    static final int NO_POSITION = -1;
    private static final int FIX_FLIPING_DURATION = 500;
    protected ListAdapter mAdapter;
    protected int mItemCount;
    Rect mListPadding = new Rect();
    int mWidthMeasureSpec = 0;
    private int mLeftViewIndex;
    private int mRightViewIndex;
    private int mCurViewIdx;
    protected int mCurrentX;
    protected int mNextX;
    private int mMaxX;
    private int mDisplayOffset;
    private HCSGestureDetector mGesture;
    protected Scroller mScroller;
    private int mLastFinalX;
    private int mLastMaxX;
    private Queue<View> mRemovedViewQueue;
    private AdapterView.OnItemSelectedListener mOnItemSelected;
    private AdapterView.OnItemClickListener mOnItemClicked;
    private AdapterView.OnItemLongClickListener mOnItemLongClicked;
    private int mOffsetTop;
    private int mOffsetLeft;
    private int mOffsetRight;
    private boolean mAlineBottom;
    private boolean mItemCenter;
    private int mItemWidth;
    private boolean bLayoutInited;
    private DRAG mCurDrag;
    private MODE mCurMode;
    private DIRECTION mScrollDirection;
    private OnItemScrollListener mOnItemScrollListener;
    private Runnable mRequestLayoutRunable = new Runnable(){

        @Override
        public void run() {
            HCSListView.this.requestLayout();
        }
    };
    private DataSetObserver mDataObserver = new DataSetObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChanged() {
            HCSListView hCSListView = HCSListView.this;
            synchronized (hCSListView) {
                HCSListView.this.mCurMode = MODE.MODE_DATA_CHANGEED;
            }
            HCSListView.this.invalidate();
            HCSListView.this.requestLayout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInvalidated() {
            HCSListView hCSListView = HCSListView.this;
            synchronized (hCSListView) {
                HCSListView.this.mCurMode = MODE.MODE_DATA_INVILID;
            }
            HCSListView.this.mLastFinalX = HCSListView.this.mScroller.getFinalX();
            HCSListView.this.mLastMaxX = HCSListView.this.mMaxX;
            HCSListView.this.invalidate();
            HCSListView.this.requestLayout();
        }
    };
    private HCSGestureDetector.OnCustomGestureListener mOnGesture = new HCSGestureDetector.OnCustomGestureListener(){

        public boolean onDown(MotionEvent e) {
            if (HCSListView.this.mCurDrag == DRAG.DRAG_FLIPPING) {
                HCSListView.this.mScroller.forceFinished(true);
                HCSListView.this.mCurDrag = DRAG.DRAG_X;
            } else {
                HCSListView.this.mScroller.forceFinished(true);
                HCSListView.this.mCurDrag = DRAG.DRAG_PRE;
            }
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (HCSListView.this.mScrollDirection == DIRECTION.BOTTOM_TO_TOP || HCSListView.this.mScrollDirection == DIRECTION.TOP_TO_BOTTOM || HCSListView.this.mScrollDirection == DIRECTION.MOVE_UNKNOWN) {
                return false;
            }
            return HCSListView.this.onFling(e1, e2, velocityX, velocityY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (HCSListView.this.mScrollDirection == DIRECTION.BOTTOM_TO_TOP || HCSListView.this.mScrollDirection == DIRECTION.TOP_TO_BOTTOM) {
                if (HCSListView.this.mOnItemScrollListener != null) {
                    HCSListView.this.mOnItemScrollListener.OnDraging(HCSListView.this, distanceX, distanceY);
                }
                if (HCSListView.this.mCurDrag == DRAG.DRAG_PRE) {
                    HCSListView.this.mCurDrag = DRAG.DRAG_Y;
                }
                return false;
            }
            if (distanceX != 0.0f) {
                if (HCSListView.this.mCurDrag == DRAG.DRAG_PRE) {
                    if (HCSListView.this.mOnItemScrollListener != null) {
                        HCSListView.this.mOnItemScrollListener.OnScrollStart(HCSListView.this);
                    }
                    HCSListView.this.mCurDrag = DRAG.DRAG_X;
                }
                HCSListView hCSListView = HCSListView.this;
                synchronized (hCSListView) {
                    HCSListView.this.mNextX += (int)distanceX;
                }
                HCSListView.this.requestLayout();
            }
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            Rect viewRect = new Rect();
            int start = HCSListView.this.getFirstVisiblePosition();
            for (int i = 0; i < HCSListView.this.getChildCount(); ++i) {
                View child = HCSListView.this.getChildAt(i);
                int left = child.getLeft();
                int right = child.getRight();
                int top = child.getTop();
                int bottom = child.getBottom();
                viewRect.set(left, top, right, bottom);
                if (!viewRect.contains((int)e.getX(), (int)e.getY())) continue;
                if (HCSListView.this.mOnItemClicked == null) break;
                HCSListView.this.mOnItemClicked.onItemClick((AdapterView)HCSListView.this, child, start + i, HCSListView.this.mAdapter.getItemId(start + i));
                break;
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            Rect viewRect = new Rect();
            int childCount = HCSListView.this.getChildCount();
            int start = HCSListView.this.getFirstVisiblePosition();
            for (int i = 0; i < childCount; ++i) {
                View child = HCSListView.this.getChildAt(i);
                int left = child.getLeft();
                int right = child.getRight();
                int top = child.getTop();
                int bottom = child.getBottom();
                viewRect.set(left, top, right, bottom);
                if (!viewRect.contains((int)e.getX(), (int)e.getY())) continue;
                if (HCSListView.this.mOnItemLongClicked == null) break;
                HCSListView.this.mOnItemLongClicked.onItemLongClick((AdapterView)HCSListView.this, child, start + i, HCSListView.this.mAdapter.getItemId(start + i));
                break;
            }
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            Log.i((String)HCSListView.this.TAG, (String)"onSingleTapUp");
            return false;
        }

        @Override
        public void OnDoubleFingerStartScroll(MotionEvent ev, int direction) {
        }

        @Override
        public void OnDoubleFingerStartZoom(MotionEvent ev) {
        }

        @Override
        public void OnDoubleFingerDown(MotionEvent ev) {
        }

        @Override
        public void OnSingleFingerEdgeIn(MotionEvent ev, int direction) {
            Log.i((String)HCSListView.this.TAG, (String)("OnSingleFingerEdgeIn = " + direction));
            HCSListView.this.mScroller.forceFinished(true);
        }

        public boolean onDoubleTap(MotionEvent e) {
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        @Override
        public boolean OnSingleFingerDrag(MotionEvent ev, int direction, float dx, float dy) {
            if (HCSListView.this.mScrollDirection == DIRECTION.MOVE_UNKNOWN) {
                HCSListView.this.mScrollDirection = DIRECTION.values()[direction];
            }
            return false;
        }
    };

    public HCSListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray att = context.obtainStyledAttributes(attrs, R.styleable.HCSListView);
        this.mOffsetTop = (int)att.getDimension(R.styleable.HCSListView_itemOffsetTop, 0.0f);
        Log.i((String)this.TAG, (String)("mOffsetTop = " + this.mOffsetTop));
        this.mOffsetLeft = (int)att.getDimension(R.styleable.HCSListView_itemOffsetLeft, 0.0f);
        Log.i((String)this.TAG, (String)("mOffsetLeft = " + this.mOffsetLeft));
        this.mItemCenter = att.getBoolean(R.styleable.HCSListView_itemCenter, false);
        this.mAlineBottom = att.getBoolean(R.styleable.HCSListView_itemAlineBottom, false);
        att.recycle();
        this.onCreate();
    }

    public HCSListView(Context context) {
        super(context);
        this.mOffsetTop = 0;
        this.mOffsetLeft = 0;
        this.mItemCenter = false;
        this.onCreate();
    }

    public HCSListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray att = context.obtainStyledAttributes(attrs, R.styleable.HCSListView);
        this.mOffsetTop = (int)att.getDimension(R.styleable.HCSListView_itemOffsetTop, 0.0f);
        Log.i((String)this.TAG, (String)("mOffsetTop = " + this.mOffsetTop));
        this.mOffsetLeft = (int)att.getDimension(R.styleable.HCSListView_itemOffsetLeft, 0.0f);
        Log.i((String)this.TAG, (String)("mOffsetLeft = " + this.mOffsetLeft));
        this.mItemCenter = att.getBoolean(R.styleable.HCSListView_itemCenter, false);
        this.mAlineBottom = att.getBoolean(R.styleable.HCSListView_itemAlineBottom, false);
        att.recycle();
        this.onCreate();
    }

    private void onCreate() {
        this.setChildrenDrawingOrderEnabled(true);
        this.mScroller = new Scroller(this.getContext());
        this.mGesture = new HCSGestureDetector(this.getContext(), this.mOnGesture);
        this.mLastFinalX = 0;
        this.mLastMaxX = Integer.MAX_VALUE;
        this.mLeftViewIndex = -1;
        this.mRightViewIndex = 0;
        this.mDisplayOffset = 0;
        this.mNextX = 0;
        this.mMaxX = Integer.MAX_VALUE;
        this.mCurViewIdx = 0;
        this.bLayoutInited = false;
        this.mCurDrag = DRAG.DRAG_IDEL;
        this.mCurMode = MODE.MODE_DATA_NORMAL;
        this.mScrollDirection = DIRECTION.MOVE_UNKNOWN;
        this.mRemovedViewQueue = new LinkedList<View>();
    }

    private synchronized void clearLayout() {
        this.mLeftViewIndex = -1;
        this.mRightViewIndex = 0;
        this.mDisplayOffset = 0;
        this.mCurrentX = this.mOffsetLeft;
        this.mNextX = 0;
        this.mMaxX = Integer.MAX_VALUE;
    }

    private boolean initLayout() {
        if (this.mAdapter == null) {
            return false;
        }
        if (!this.bLayoutInited && this.mAdapter.getCount() > 0) {
            View child = this.mAdapter.getView(0, null, (ViewGroup)this);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-2, -1);
                child.setLayoutParams(lp);
            }
            int childWidthMeasureSpec = HCSListView.getChildMeasureSpec((int)this.getMeasuredWidth(), (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
            int childHeightMeasureSpec = HCSListView.getChildMeasureSpec((int)this.getMeasuredHeight(), (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.mItemWidth = child.getMeasuredWidth();
            Log.i((String)this.TAG, (String)("Item W=" + this.mItemWidth + "H=" + child.getMeasuredHeight()));
            Log.i((String)this.TAG, (String)("View W=" + this.getMeasuredWidth() + ",H=" + this.getMeasuredHeight()));
            int showCount = 0;
            if (this.mItemCenter) {
                int halfCount;
                this.mOffsetRight = (int)(Math.ceil((float)(this.getMeasuredWidth() - this.mItemWidth) / 2.0f) - (double)this.mOffsetLeft);
                this.mOffsetLeft += (int)Math.ceil((float)(this.getMeasuredWidth() - this.mItemWidth) / 2.0f);
                showCount = this.getMeasuredWidth() / this.mItemWidth;
                if (this.getMeasuredWidth() % this.mItemWidth != 0) {
                    showCount += 2;
                }
                this.mLeftViewIndex = (halfCount = showCount / 2) <= this.mCurViewIdx ? this.mCurViewIdx - halfCount : this.mCurViewIdx - 1;
            } else {
                this.mOffsetRight = this.mOffsetLeft;
                showCount = this.getMeasuredWidth() / this.mItemWidth;
                if (this.getMeasuredWidth() % this.mItemWidth != 0) {
                    ++showCount;
                }
                this.mLeftViewIndex = showCount <= this.mCurViewIdx ? this.mCurViewIdx - showCount : -1;
            }
            this.mRightViewIndex = this.mCurViewIdx;
            int fix = this.mCurViewIdx * this.mItemWidth;
            Log.i((String)this.TAG, (String)("mCurrentX = " + this.mCurrentX + " fix = " + fix));
            Log.i((String)this.TAG, (String)("mScroller = " + this.mScroller.getCurrX() + ",mLeftViewIndex =" + this.mLeftViewIndex));
            this.mCurrentX = this.mOffsetLeft + (fix - this.mScroller.getCurrX());
            this.mScroller.setFinalX(fix);
            Log.i((String)this.TAG, (String)("mScroller = " + this.mScroller.getCurrX()));
            this.bLayoutInited = true;
        }
        return this.bLayoutInited;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelected = listener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        super.setOnItemClickListener(listener);
        this.mOnItemClicked = listener;
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        super.setOnItemLongClickListener(listener);
        this.mOnItemLongClicked = listener;
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        int center = this.mCurViewIdx - this.getFirstVisiblePosition();
        int temp = center + (childCount - 1);
        if (center >= 0 && center < childCount) {
            if (i < center) {
                return i;
            }
            return temp - i;
        }
        return i;
    }

    public int getFirstVisiblePosition() {
        return this.mLeftViewIndex < 0 ? 0 : this.mLeftViewIndex + 1;
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver(this.mDataObserver);
        this.reset();
    }

    public View getSelectedView() {
        return null;
    }

    private synchronized void reset() {
        this.mScroller = new Scroller(this.getContext());
        this.mGesture = new HCSGestureDetector(this.getContext(), this.mOnGesture);
        this.clearLayout();
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void setSelection(int position) {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mAdapter.getCount() <= 0) {
            return;
        }
        this.mCurDrag = DRAG.DRAG_FLIPPING;
        this.mCurViewIdx = position;
        int fix = this.mCurViewIdx * this.getChildViewWidth();
        Log.i((String)this.TAG, (String)("setSelection mCurrentX = " + this.mCurrentX + " fix = " + fix));
        Log.i((String)this.TAG, (String)("setSelection mScroller = " + this.mScroller.getCurrX()));
        this.mLeftViewIndex = this.mCurViewIdx - 1;
        this.mRightViewIndex = this.mCurViewIdx;
        this.mCurrentX = this.mOffsetLeft + (fix - this.mScroller.getCurrX());
        this.mScroller.setFinalX(fix);
        this.post(this.mRequestLayoutRunable);
    }

    public void addView(View child, int idx) {
        this.addAndMeasureChild(child, idx);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mListPadding.left = super.getPaddingLeft();
        this.mListPadding.top = super.getPaddingTop();
        this.mListPadding.right = super.getPaddingRight();
        this.mListPadding.bottom = super.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            View child = this.obtainView(0);
            this.measureScrapChild(child, 0, heightMeasureSpec);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            this.mRemovedViewQueue.offer(child);
        }
        if (widthMode == 0) {
            widthSize = this.mListPadding.left + this.mListPadding.right + childWidth + this.getVerticalScrollbarWidth();
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = this.measureWidthOfChildren(heightMeasureSpec, 0, -1, widthSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    View obtainView(int position) {
        return this.mAdapter.getView(position, this.mRemovedViewQueue.poll(), (ViewGroup)this);
    }

    private void measureScrapChild(View child, int position, int heightMeasureSpec) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
            child.setLayoutParams(p);
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
        int lpWidth = p.width;
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    final int measureWidthOfChildren(int heightMeasureSpec, int startPosition, int endPosition, int maxWidth, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.left + this.mListPadding.right;
        }
        int returnedWidth = this.mListPadding.left + this.mListPadding.right;
        int prevHeightWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        for (int i = startPosition; i <= endPosition; ++i) {
            View child = this.obtainView(i);
            this.measureScrapChild(child, i, heightMeasureSpec);
            this.mRemovedViewQueue.offer(child);
            if ((returnedWidth += child.getMeasuredWidth()) >= maxWidth) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedWidth != maxWidth ? prevHeightWithoutPartialChild : maxWidth;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedWidth;
        }
        return returnedWidth;
    }

    private int getChildViewWidth() {
        if (this.bLayoutInited) {
            return this.mItemWidth;
        }
        return 0;
    }

    private void addAndMeasureChild(View child, int viewPos) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -1);
        }
        this.addViewInLayout(child, viewPos, params, true);
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = HCSListView.getChildMeasureSpec((int)this.getMeasuredWidth(), (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
        int childHeightMeasureSpec = HCSListView.getChildMeasureSpec((int)this.getMeasuredHeight(), (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private void flipingFix(int offset) {
        int width = this.getChildViewWidth();
        if (width != 0 && this.mCurDrag == DRAG.DRAG_FLIPPING) {
            int fix = Math.round((float)offset / (float)width) * width;
            if (this.mScrollDirection == DIRECTION.RIGHT_TO_LEFT) {
                fix = (int)(Math.ceil((float)offset / (float)width) * (double)width);
            } else if (this.mScrollDirection == DIRECTION.LEFT_TO_RIGHT) {
                fix = (int)(Math.floor((float)offset / (float)width) * (double)width);
            }
            if (fix != this.mCurrentX && fix <= this.mMaxX) {
                int time = Math.abs(fix - offset) * 500 / width;
                this.mScroller.startScroll(offset, 0, fix - offset, 0, time);
                this.post(this.mRequestLayoutRunable);
            } else {
                if (this.mOnItemScrollListener != null) {
                    int center = this.mCurViewIdx - this.getFirstVisiblePosition();
                    this.mOnItemScrollListener.OnScrollEnd(this, center);
                    this.mScrollDirection = DIRECTION.MOVE_UNKNOWN;
                }
                this.mCurDrag = DRAG.DRAG_IDEL;
            }
        }
    }

    protected synchronized void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.initLayout()) {
            return;
        }
        if (this.mCurMode == MODE.MODE_DATA_CHANGEED) {
            int oldCurrentX = this.mCurrentX;
            this.clearLayout();
            this.removeAllViewsInLayout();
            this.mNextX = oldCurrentX;
        } else if (this.mCurMode == MODE.MODE_DATA_INVILID) {
            this.clearLayout();
            this.removeAllViewsInLayout();
            this.mNextX = this.mLastFinalX;
            this.mMaxX = this.mLastMaxX;
        }
        if (this.mScroller.computeScrollOffset()) {
            int scrollx;
            this.mNextX = scrollx = this.mScroller.getCurrX();
        }
        if (this.mNextX <= 0) {
            this.mNextX = 0;
            this.mScroller.forceFinished(true);
        }
        if (this.mNextX >= this.mMaxX) {
            this.mNextX = this.mMaxX;
            this.mScroller.forceFinished(true);
        }
        int dx = this.mCurrentX - this.mNextX;
        this.removeNonVisibleItems(dx);
        this.fillList(dx);
        this.positionItems(dx);
        this.mCurrentX = this.mNextX;
        this.mCurMode = MODE.MODE_DATA_NORMAL;
        if (!this.mScroller.isFinished()) {
            this.post(this.mRequestLayoutRunable);
        } else if (this.mItemCenter) {
            this.flipingFix(this.mCurrentX);
        } else if (this.mOnItemScrollListener != null) {
            this.mOnItemScrollListener.OnScrollEnd(this, this.mCurViewIdx);
        }
    }

    private void fillList(int dx) {
        int edge = 0;
        View child = this.getChildAt(this.getChildCount() - 1);
        if (child != null) {
            edge = child.getRight();
        }
        this.fillListRight(edge, dx);
        edge = 0;
        child = this.getChildAt(0);
        if (child != null) {
            edge = child.getLeft();
        }
        this.fillListLeft(edge, dx);
    }

    private void fillListRight(int rightEdge, int dx) {
        while (rightEdge + dx < this.getWidth() && this.mRightViewIndex < this.mAdapter.getCount()) {
            View child = this.mAdapter.getView(this.mRightViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, -1);
            rightEdge += child.getMeasuredWidth();
            if (this.mRightViewIndex == this.mAdapter.getCount() - 1) {
                this.mMaxX = this.mCurrentX + rightEdge - this.getWidth() + this.mOffsetRight;
            }
            if (this.mMaxX <= -this.mOffsetLeft) {
                this.mMaxX = -this.mOffsetLeft;
            }
            ++this.mRightViewIndex;
        }
    }

    private void fillListLeft(int leftEdge, int dx) {
        while (leftEdge + dx > 0 && this.mLeftViewIndex >= 0) {
            View child = this.mAdapter.getView(this.mLeftViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, 0);
            leftEdge -= child.getMeasuredWidth();
            --this.mLeftViewIndex;
            this.mDisplayOffset -= child.getMeasuredWidth();
        }
    }

    private void removeNonVisibleItems(int dx) {
        View child = this.getChildAt(0);
        while (child != null && child.getRight() + dx <= 0) {
            this.mDisplayOffset += child.getMeasuredWidth();
            this.mRemovedViewQueue.offer(child);
            child.clearAnimation();
            this.removeViewInLayout(child);
            ++this.mLeftViewIndex;
            child = this.getChildAt(0);
        }
        child = this.getChildAt(this.getChildCount() - 1);
        while (child != null && child.getLeft() + dx >= this.getWidth()) {
            this.mRemovedViewQueue.offer(child);
            child.clearAnimation();
            this.removeViewInLayout(child);
            --this.mRightViewIndex;
            child = this.getChildAt(this.getChildCount() - 1);
        }
    }

    private void updateSelected() {
        View center = null;
        int start = this.getFirstVisiblePosition();
        for (int i = 0; i < this.getChildCount(); ++i) {
            center = this.getChildAt(i);
            if (center.getLeft() > this.mOffsetLeft || center.getRight() <= this.mOffsetLeft) continue;
            int dstLeft = center.getRight() - this.mOffsetLeft;
            float percet = (float)dstLeft / (float)this.getChildViewWidth();
            if (this.mOnItemScrollListener != null) {
                this.mOnItemScrollListener.OnScrollCenter(this, center, i, percet);
            }
            if (this.mCurMode == MODE.MODE_DATA_CHANGEED || !this.mItemCenter) break;
            this.mCurViewIdx = start + i;
            if (this.mOnItemSelected == null) break;
            this.mOnItemSelected.onItemSelected((AdapterView)this, center, this.mCurViewIdx, this.mAdapter.getItemId(this.mCurViewIdx));
            break;
        }
    }

    private void positionItems(int dx) {
        if (this.getChildCount() > 0) {
            this.mDisplayOffset += dx;
            int left = this.mDisplayOffset;
            int height = this.getMeasuredHeight();
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                if (!this.mAlineBottom) {
                    child.layout(left, this.mOffsetTop, left + childWidth, this.mOffsetTop + childHeight);
                } else {
                    child.layout(left, height - childHeight, left + childWidth, height);
                }
                left += childWidth;
            }
            this.updateSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollTo(int x) {
        HCSListView hCSListView = this;
        synchronized (hCSListView) {
            this.mScroller.startScroll(this.mNextX, 0, x - this.mNextX, 0);
            this.requestLayout();
        }
    }

    public void setOnItemScrollListener(OnItemScrollListener mOnItemScrollListener) {
        this.mOnItemScrollListener = mOnItemScrollListener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        super.dispatchTouchEvent(ev);
        this.mGesture.onTouchEvent(ev);
        switch (ev.getAction() & 0xFF) {
            case 1: 
            case 3: {
                Log.i((String)this.TAG, (String)("mCurDrag = " + (Object)((Object)this.mCurDrag)));
                if (this.mCurDrag == DRAG.DRAG_X) {
                    int width;
                    this.mScroller.setFinalX(this.mNextX);
                    this.mScroller.forceFinished(true);
                    int time = 500;
                    if (this.mItemCenter && (width = this.getChildViewWidth()) != 0) {
                        int fix = Math.round((float)this.mScroller.getFinalX() / (float)width) * width;
                        time = 500 * Math.abs(width - Math.abs(fix - this.mScroller.getFinalX())) / width;
                        this.mScroller.setFinalX(fix);
                        this.mScroller.forceFinished(true);
                    }
                    this.mScroller.startScroll(this.mNextX, 0, this.mScroller.getFinalX() - this.mNextX, 0, time);
                    this.post(this.mRequestLayoutRunable);
                    this.mCurDrag = DRAG.DRAG_FLIPPING;
                    break;
                }
                if (this.mCurDrag != DRAG.DRAG_Y) break;
                this.mCurDrag = DRAG.DRAG_IDEL;
                if (this.mOnItemScrollListener == null || !this.mOnItemScrollListener.OnDragingOver(this)) break;
                this.mScrollDirection = DIRECTION.MOVE_UNKNOWN;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.mScroller.fling(this.mNextX, 0, (int)(-velocityX), 0, 0, this.mMaxX, 0, 0);
        HCSListView hCSListView = this;
        synchronized (hCSListView) {
            int width;
            if (this.mItemCenter && (width = this.getChildViewWidth()) != 0 && this.mCurDrag == DRAG.DRAG_X) {
                int offset = this.mScroller.getFinalX();
                int time = this.mScroller.getDuration();
                int fix = Math.round((float)offset / (float)width) * width;
                if (this.mScrollDirection == DIRECTION.RIGHT_TO_LEFT) {
                    fix = (int)(Math.ceil((float)offset / (float)width) * (double)width);
                } else if (this.mScrollDirection == DIRECTION.LEFT_TO_RIGHT) {
                    fix = (int)(Math.floor((float)offset / (float)width) * (double)width);
                }
                if (Build.VERSION.SDK_INT > 10) {
                    this.mScroller.setFinalX(fix);
                } else {
                    this.mScroller.forceFinished(true);
                    this.mScroller.startScroll(this.mNextX, 0, fix - this.mNextX, 0, time);
                }
            }
            this.mCurDrag = DRAG.DRAG_FLIPPING;
        }
        this.requestLayout();
        return true;
    }

    public static interface OnItemScrollListener {
        public void OnScrollCenter(AdapterView<ListAdapter> var1, View var2, int var3, float var4);

        public void OnScrollStart(AdapterView<ListAdapter> var1);

        public void OnScrollEnd(AdapterView<ListAdapter> var1, int var2);

        public boolean OnDraging(AdapterView<ListAdapter> var1, float var2, float var3);

        public boolean OnDragingOver(AdapterView<ListAdapter> var1);
    }

    private static enum DIRECTION {
        MOVE_UNKNOWN,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }

    private static enum MODE {
        MODE_DATA_NORMAL,
        MODE_DATA_CHANGEED,
        MODE_DATA_INVILID;

    }

    private static enum DRAG {
        DRAG_IDEL,
        DRAG_FLIPPING,
        DRAG_PRE,
        DRAG_X,
        DRAG_Y;

    }
}

