/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import com.guo.android_extend.widget.Camera2GLSurfaceView;
import java.util.ArrayList;
import java.util.List;

public class Camera2Manager {
    private final String TAG = this.getClass().getSimpleName();
    CameraManager mCameraManager;
    List<VirtualCamera> mVirtualCamera;
    HandlerThread mHandlerThread;
    Handler mHandler;
    Camera2GLSurfaceView.OnCameraListener mOnCameraListener;
    OnDataListener mOnDataListener;
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            super.onCaptureStarted(session, request, timestamp, frameNumber);
            if (request.getTag() == "FOCUS_TAG") {
                Log.d((String)Camera2Manager.this.TAG, (String)("onCaptureStarted:" + timestamp + ",request=" + request.toString()));
                if (Camera2Manager.this.mOnCameraListener != null) {
                    Camera2Manager.this.mOnCameraListener.onCameraEvent(session.getDevice().getId(), 0);
                }
            }
        }
    };

    public Camera2Manager(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mHandler = null;
        this.mHandlerThread = null;
    }

    public void setOnDataListener(OnDataListener mOnDataListener) {
        this.mOnDataListener = mOnDataListener;
    }

    public void setOnCameraListener(Camera2GLSurfaceView.OnCameraListener lis) {
        this.mOnCameraListener = lis;
    }

    public boolean openCamera() {
        try {
            this.mHandlerThread = new HandlerThread("Camera2");
            this.mHandlerThread.start();
            this.mHandler = new Handler(this.mHandlerThread.getLooper());
            String[] camera_ids = null;
            camera_ids = this.mOnCameraListener != null ? this.mOnCameraListener.chooseCamera(this.mCameraManager.getCameraIdList()) : new String[]{this.mCameraManager.getCameraIdList()[0]};
            this.mVirtualCamera = new ArrayList<VirtualCamera>();
            for (int i = 0; i < camera_ids.length; ++i) {
                VirtualCamera vc = new VirtualCamera();
                vc.mCameraCharacteristics = this.mCameraManager.getCameraCharacteristics(camera_ids[i]);
                try {
                    this.mCameraManager.openCamera(camera_ids[i], vc.mCDStateCallback, this.mHandler);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                this.mVirtualCamera.add(vc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void closeCamera() {
        for (VirtualCamera camera : this.mVirtualCamera) {
            camera.close();
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            try {
                this.mHandlerThread.join();
                this.mHandlerThread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void touchFocus(View view, MotionEvent ev) {
        if (this.mVirtualCamera != null) {
            for (VirtualCamera camera : this.mVirtualCamera) {
                Rect sensorArraySize = (Rect)camera.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                int ori = (Integer)camera.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                Log.d((String)this.TAG, (String)("ORI=" + ori + "<" + view.getWidth() + "," + view.getHeight() + ">" + "<" + sensorArraySize.width() + "," + sensorArraySize.height() + ">"));
                int x = (int)(ev.getX() / (float)view.getWidth() * (float)sensorArraySize.height());
                int y = (int)(ev.getY() / (float)view.getHeight() * (float)sensorArraySize.width());
                int halfTouchWidth = 150;
                int halfTouchHeight = 150;
                MeteringRectangle focusArea = new MeteringRectangle(Math.max(x - 150, 0), Math.max(y - 150, 0), 300, 300, 1000);
                if (camera.mPreviewBuilder != null) {
                    camera.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{focusArea});
                    camera.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                    camera.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                    camera.mPreviewBuilder.setTag((Object)"FOCUS_TAG");
                }
                try {
                    camera.mCameraCaptureSession.capture(camera.mPreviewBuilder.build(), this.mCaptureCallback, this.mHandler);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void startPreview(VirtualCamera vc) {
        ArrayList<Surface> list = new ArrayList<Surface>();
        CameraDevice camera = vc.mCameraDevice;
        ImageReader reader = vc.mImageReader;
        CaptureRequest.Builder builder = vc.mPreviewBuilder;
        if (reader != null) {
            list.add(reader.getSurface());
        }
        if (builder != null) {
            for (Surface surface : list) {
                builder.addTarget(surface);
            }
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        }
        try {
            camera.createCaptureSession(list, vc.mCCSStateCallback, this.mHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    class VirtualCamera
    implements ImageReader.OnImageAvailableListener {
        CameraCharacteristics mCameraCharacteristics;
        CameraDevice mCameraDevice;
        CameraCaptureSession mCameraCaptureSession;
        ImageReader mImageReader;
        CaptureRequest.Builder mPreviewBuilder;
        CameraDevice.StateCallback mCDStateCallback = new CameraDevice.StateCallback(){

            public void onOpened(CameraDevice camera) {
                Log.d((String)Camera2Manager.this.TAG, (String)("onOpened:" + camera.getId()));
                try {
                    VirtualCamera.this.mCameraDevice = camera;
                    VirtualCamera.this.mPreviewBuilder = camera.createCaptureRequest(1);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                }
                if (Camera2Manager.this.mOnCameraListener != null) {
                    VirtualCamera.this.mImageReader = Camera2Manager.this.mOnCameraListener.setupPreview(VirtualCamera.this.mCameraDevice.getId(), VirtualCamera.this.mCameraCharacteristics, VirtualCamera.this.mPreviewBuilder);
                    VirtualCamera.this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)VirtualCamera.this, Camera2Manager.this.mHandler);
                }
                Camera2Manager.this.startPreview(VirtualCamera.this);
            }

            public void onDisconnected(CameraDevice camera) {
                Log.d((String)Camera2Manager.this.TAG, (String)("onDisconnected:" + camera.getId()));
            }

            public void onError(CameraDevice camera, int error) {
                switch (error) {
                    case 4: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", ERROR_CAMERA_DEVICE=" + error));
                        break;
                    }
                    case 3: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", ERROR_CAMERA_DISABLED=" + error));
                        break;
                    }
                    case 1: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", ERROR_CAMERA_IN_USE=" + error));
                        break;
                    }
                    case 5: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", ERROR_CAMERA_SERVICE=" + error));
                        break;
                    }
                    case 2: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", ERROR_MAX_CAMERAS_IN_USE=" + error));
                        break;
                    }
                    default: {
                        Log.d((String)Camera2Manager.this.TAG, (String)("onError id:" + camera.getId() + ", code=" + error));
                    }
                }
                if (Camera2Manager.this.mOnCameraListener != null) {
                    Camera2Manager.this.mOnCameraListener.onCameraEvent(camera.getId(), error | 0x1000);
                }
            }
        };
        CameraCaptureSession.StateCallback mCCSStateCallback = new CameraCaptureSession.StateCallback(){

            public void onConfigured(CameraCaptureSession session) {
                Log.d((String)Camera2Manager.this.TAG, (String)("onConfigured:" + session.toString()));
                VirtualCamera.this.mCameraCaptureSession = session;
                try {
                    session.setRepeatingRequest(VirtualCamera.this.mPreviewBuilder.build(), Camera2Manager.this.mCaptureCallback, Camera2Manager.this.mHandler);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                }
            }

            public void onConfigureFailed(CameraCaptureSession session) {
                Log.d((String)Camera2Manager.this.TAG, (String)("onConfigureFailed:" + session.toString()));
            }
        };

        VirtualCamera() {
        }

        public void close() {
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mCameraCaptureSession) {
                this.mCameraCaptureSession.close();
                this.mCameraCaptureSession = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }

        public void onImageAvailable(ImageReader imageReader) {
            Image image = imageReader.acquireNextImage();
            Image.Plane[] colors = image.getPlanes();
            boolean size = false;
            int cur = 0;
            byte[] bytes = new byte[image.getWidth() * image.getHeight() * 3 / 2];
            if (image.getFormat() == 35) {
                int length = colors[0].getBuffer().remaining();
                colors[0].getBuffer().get(bytes, cur, length);
                length = colors[1].getBuffer().remaining();
                colors[1].getBuffer().get(bytes, cur += image.getWidth() * image.getHeight(), length);
            }
            boolean display = false;
            if (Camera2Manager.this.mOnCameraListener != null) {
                display = Camera2Manager.this.mOnCameraListener.onPreview(this.mCameraDevice.getId(), bytes, image.getWidth(), image.getHeight(), image.getFormat(), image.getTimestamp());
            }
            image.close();
            if (display && Camera2Manager.this.mOnDataListener != null) {
                Camera2Manager.this.mOnDataListener.onPreviewData(bytes);
            }
        }
    }

    public static interface OnDataListener {
        public void onPreviewData(byte[] var1);
    }
}

