/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.tools;

import com.guo.android_extend.java.AbsLoop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class DumpHelper
extends AbsLoop {
    private String tag;
    private String path;
    private String suffix;
    private LinkedBlockingQueue<DataInterface> writeQueue;
    private FileOutputStream out;

    public DumpHelper(String tag, String path, String suffix) {
        this.tag = tag;
        this.path = path;
        this.suffix = suffix;
    }

    @Override
    public void setup() {
        this.writeQueue = new LinkedBlockingQueue();
        try {
            this.out = new FileOutputStream(new File(this.path, this.tag + "." + this.suffix));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean write(DataInterface data) {
        if (this.writeQueue != null) {
            try {
                this.writeQueue.put(data);
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void loop() {
        DataInterface data = null;
        try {
            data = this.writeQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (data != null) {
            try {
                byte[] real = data.convert();
                if (real != null) {
                    this.out.write(real);
                } else {
                    this.break_loop();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void over() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean force) {
        block9: {
            if (force) {
                try {
                    this.writeQueue.put(new FinishData());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                super.shutdown();
            } else {
                try {
                    this.writeQueue.put(new FinishData());
                    if (this == Thread.currentThread()) break block9;
                    DumpHelper e = this;
                    synchronized (e) {
                        this.notifyAll();
                    }
                    this.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class FinishData
    implements DataInterface {
        private FinishData() {
        }

        @Override
        public byte[] convert() {
            return null;
        }
    }

    public static interface DataInterface {
        public byte[] convert();
    }
}

