/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.java.network.udp;

import com.guo.android_extend.java.network.udp.UDPDataProtocol;
import com.guo.android_extend.java.network.udp.UDPTransponder;
import com.guo.android_extend.tools.LogcatHelper;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class UDPModule
implements UDPDataProtocol {
    private String TAG = this.getClass().getSimpleName();
    private List<Device> mDevices;
    private UDPTransponder mUDPTransponder;
    private OnUDPListener mOnClientListener;
    private String mName;
    private String mLocalMac;

    public UDPModule(InetAddress inetAddress, boolean isBroadcast, String mac, String name) {
        this(inetAddress, isBroadcast, mac, name, 1000);
    }

    public UDPModule(InetAddress inetAddress, boolean isBroadcast, String mac, String name, int time) {
        this.mName = name;
        this.mUDPTransponder = new UDPTransponder(inetAddress, isBroadcast);
        this.mUDPTransponder.setUDPDataProtocol(this);
        this.mUDPTransponder.startReceiver();
        this.mUDPTransponder.startDeliver(time);
        this.mDevices = new ArrayList<Device>();
        this.mLocalMac = mac;
    }

    public List<Device> getResult() {
        return this.mDevices;
    }

    public void clear() {
        this.mDevices.clear();
    }

    public void destroy() {
        this.mUDPTransponder.stopDeliver();
        this.mUDPTransponder.stopReceiver();
    }

    public void setOnUDPListener(OnUDPListener osl) {
        this.mOnClientListener = osl;
    }

    @Override
    public byte[] packaged() {
        String ret = this.mName + "#" + this.mLocalMac;
        return ret.getBytes();
    }

    @Override
    public void parsed(String ip, byte[] data, int size) {
        String info = new String(data, 0, size);
        String[] list = info.split("#");
        if (list.length <= 1) {
            LogcatHelper.e(this.TAG, "parser error!" + info + ",ip=" + ip);
            return;
        }
        String name = list[0];
        String mac = list[1];
        boolean update = true;
        for (Device device : this.mDevices) {
            if (!device.mMAC.equals(mac)) continue;
            update = false;
            break;
        }
        if (update && !mac.equals(this.mLocalMac)) {
            LogcatHelper.d(this.TAG, "Device:" + name + "[" + mac + "]" + "<" + ip + ">");
            this.mDevices.add(new Device(name, ip, mac));
            if (this.mOnClientListener != null) {
                this.mOnClientListener.onReceiveDevice(this.mDevices, name, ip);
            }
        }
    }

    public static interface OnUDPListener {
        public void onReceiveDevice(List<Device> var1, String var2, String var3);
    }

    public class Device {
        public String mName;
        public String mIP;
        public String mMAC;

        public Device(String mName, String mIP, String mMAC) {
            this.mName = mName;
            this.mIP = mIP;
            this.mMAC = mMAC;
        }
    }
}

