/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;

public class VerticalSeekBar
extends SeekBar {
    public VerticalSeekBar(Context context) {
        super(context);
    }

    public VerticalSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public VerticalSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
        super.onSizeChanged(this.getMeasuredHeight(), this.getMeasuredWidth(), 0, 0);
    }

    protected void onDraw(Canvas c) {
        c.rotate(-90.0f);
        c.translate((float)(-this.getHeight()), 0.0f);
        super.onDraw(c);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: 
            case 1: 
            case 2: {
                int i = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                this.setProgress(i);
                break;
            }
        }
        return true;
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
    }
}

