/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExtOrientationDetector
extends OrientationEventListener {
    private final String TAG = ((Object)((Object)this)).getClass().toString();
    public static final int ROTATE_POSITIVE = 0;
    public static final int ROTATE_NEGATIVE = 1;
    public static final int ROTATE_UNCHANGE = 2;
    public static final int ROTATE_FORCE_REDO = 3;
    private Display mDisplay;
    private Context mContext;
    private int mOrientation;
    private int mCompensation;
    private int mFixedDegree;
    private int mDegree;
    private int mMinDegree;
    private int mMaxDegree;
    private List<OnOrientationListener> mObjectes;
    private int[] mDivider;
    private List<Integer> mWorkingDegree;
    private static final int ORIENTATION_START = 0;
    private static final int ORIENTATION_DIVIDE = 4;
    private int mOffset;
    private int mHysteresis;

    public ExtOrientationDetector(Context context, int rate) {
        super(context, rate);
        this.PreCreate(context);
    }

    public ExtOrientationDetector(Context context, int first_degree, int count) {
        super(context);
        this.PreCreate(context);
        this.config(first_degree, count);
    }

    public ExtOrientationDetector(Context context) {
        super(context);
        this.PreCreate(context);
        this.config(0, 4);
    }

    private void PreCreate(Context context) {
        this.mContext = context;
        this.mObjectes = new ArrayList<OnOrientationListener>();
        this.mOrientation = -1;
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        this.mDisplay = wm.getDefaultDisplay();
        this.mFixedDegree = this.getFixedRotation();
        Log.i((String)this.TAG, (String)("FixedDegree = " + this.mFixedDegree));
    }

    private void def_config() {
        this.mDegree = 0;
        this.mOffset = 90;
        this.mHysteresis = this.mOffset / 2;
        this.mDivider = new int[4];
        this.mWorkingDegree = new ArrayList<Integer>();
        this.mDivider[0] = 0 + this.mHysteresis;
        this.mWorkingDegree.add(0);
        for (int i = 1; i < this.mDivider.length; ++i) {
            this.mDivider[i] = this.mDivider[i - 1] + this.mOffset;
            this.mWorkingDegree.add(this.mDivider[i] - this.mHysteresis);
        }
        this.mMinDegree = 0;
        this.mMaxDegree = this.mDivider[this.mDivider.length - 1] - this.mHysteresis;
    }

    private void config(int first_degree, int count) {
        this.mDegree = first_degree;
        this.mOffset = 360 / count;
        this.mHysteresis = this.mOffset / 2;
        this.mDivider = new int[count];
        this.mWorkingDegree = new ArrayList<Integer>();
        this.mDivider[0] = first_degree + this.mHysteresis;
        this.mWorkingDegree.add(first_degree);
        for (int i = 1; i < this.mDivider.length; ++i) {
            this.mDivider[i] = this.mDivider[i - 1] + this.mOffset;
            this.mWorkingDegree.add(this.mDivider[i] - this.mHysteresis);
        }
        this.mMinDegree = first_degree;
        this.mMaxDegree = this.mDivider[this.mDivider.length - 1] - this.mHysteresis;
    }

    public List<Integer> getDegrees() {
        return this.mWorkingDegree;
    }

    private boolean forceOrientationChanged(OnOrientationListener listener, int degree, int flag) {
        int param = flag;
        int offset = this.mOffset;
        if (flag == 3) {
            param = this.getRotateFlag(listener.getCurrentOrientationDegree(), degree);
        }
        int n = offset = (offset = Math.abs(listener.getCurrentOrientationDegree() - degree)) > 180 ? 360 - offset : offset;
        if (param == 1) {
            offset = -offset;
        } else if (param != 0) {
            return true;
        }
        return listener.OnOrientationChanged(degree, offset, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceOrientationChanged(int degree, int flag) {
        List<OnOrientationListener> list = this.mObjectes;
        synchronized (list) {
            Iterator<OnOrientationListener> it = this.mObjectes.iterator();
            int param = flag;
            int offset = this.mOffset;
            while (it.hasNext()) {
                OnOrientationListener listener = it.next();
                if (flag == 3) {
                    param = this.getRotateFlag(listener.getCurrentOrientationDegree(), degree);
                }
                int n = offset = (offset = Math.abs(listener.getCurrentOrientationDegree() - degree)) > 180 ? 360 - offset : offset;
                if (param == 1) {
                    offset = -offset;
                } else if (param != 0) continue;
                if (listener.OnOrientationChanged(degree, offset, param)) continue;
                it.remove();
            }
            this.mDegree = degree;
        }
    }

    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        this.mOrientation = this.roundOrientation(orientation, this.mOrientation);
        if (this.mCompensation != this.mOrientation) {
            this.mCompensation = this.mOrientation;
            int degree = this.mCompensation % 360;
            int flag = this.getRotateFlag(this.mDegree, degree);
            this.forceOrientationChanged(degree, flag);
        }
    }

    public void forceOrientationChanged() {
        this.forceOrientationChanged(this.mDegree, 3);
    }

    public int getCurrentOrientationDegree() {
        return this.mDegree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReceiver(OnOrientationListener obj) {
        List<OnOrientationListener> list = this.mObjectes;
        synchronized (list) {
            if (!this.mObjectes.contains(obj)) {
                this.forceOrientationChanged(obj, this.mDegree, 3);
                return this.mObjectes.add(obj);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReceiver(OnOrientationListener obj) {
        List<OnOrientationListener> list = this.mObjectes;
        synchronized (list) {
            if (this.mObjectes.contains(obj)) {
                return this.mObjectes.remove(obj);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReceiver() {
        List<OnOrientationListener> list = this.mObjectes;
        synchronized (list) {
            this.mObjectes.clear();
        }
    }

    private int getRotateFlag(int curdegree, int degree) {
        if (curdegree > degree && (curdegree != this.mMaxDegree || degree != this.mMinDegree) || curdegree == this.mMinDegree && degree == this.mMaxDegree) {
            return 1;
        }
        if (curdegree < degree && (curdegree != this.mMinDegree || degree != this.mMaxDegree) || curdegree == this.mMaxDegree && degree == this.mMinDegree) {
            return 0;
        }
        return 2;
    }

    private int getFixedRotation() {
        switch (this.mDisplay.getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 270;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 90;
            }
        }
        return 0;
    }

    private int roundOrientation(int cur, int pre) {
        if ((cur -= this.mFixedDegree) < 0) {
            cur += 360;
        }
        if (pre != -1) {
            int dist = Math.abs(cur - pre);
            if ((dist = Math.min(dist, 360 - dist)) < this.mHysteresis) {
                return pre;
            }
        }
        for (int i = 0; i < this.mDivider.length; ++i) {
            if (cur > this.mDivider[i]) continue;
            return this.mDivider[i] - this.mHysteresis;
        }
        return this.mDivider[0] - this.mHysteresis;
    }

    public static interface OnOrientationListener {
        public boolean OnOrientationChanged(int var1, int var2, int var3);

        public int getCurrentOrientationDegree();
    }
}

