/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import com.guo.android_extend.widget.ExtOrientationDetector;
import com.guo.android_extend.widget.RotateRunable;
import com.guo.android_extend.widget.controller.TouchController;

public class ExtGLSurfaceView
extends GLSurfaceView
implements ExtOrientationDetector.OnOrientationListener {
    private final String TAG = this.getClass().getSimpleName();
    private Handler mHandler;
    private final int ANIMATION_TIME = 300;
    private int mCurDegree;
    private double mAspectRatio;
    private boolean mFitMaxArea;
    private TouchController mTouchController;
    private TouchController.OnDispatchTouchEventListener mOnDispatchTouchEventListener;

    public ExtGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreate();
    }

    public ExtGLSurfaceView(Context context) {
        super(context);
        this.onCreate();
    }

    private void onCreate() {
        this.mAspectRatio = 0.0;
        this.mCurDegree = 0;
        this.mHandler = new Handler();
        this.mTouchController = new TouchController();
    }

    public void setAutoFitMax(boolean enable) {
        this.mFitMaxArea = enable;
    }

    public void setAspectRatio(double ratio) {
        if (this.mAspectRatio != ratio) {
            this.mAspectRatio = ratio;
            this.requestLayout();
        }
    }

    public void setAspectRatio(int width, int height) {
        double ratio = (double)width / (double)height;
        if (this.mAspectRatio != ratio) {
            this.mAspectRatio = ratio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int width = View.MeasureSpec.getSize((int)widthSpec);
        int height = View.MeasureSpec.getSize((int)heightSpec);
        if (this.mAspectRatio != 0.0) {
            int w1 = width;
            int h1 = height;
            if ((double)w1 > (double)h1 * this.mAspectRatio) {
                w1 = (int)((double)h1 * this.mAspectRatio + 0.5);
            } else {
                h1 = (int)((double)w1 / this.mAspectRatio + 0.5);
            }
            if (this.mFitMaxArea) {
                int w2 = width;
                int h2 = height;
                double ratio = 1.0 / this.mAspectRatio;
                if ((double)w2 > (double)h2 * ratio) {
                    w2 = (int)((double)h2 * ratio + 0.5);
                } else {
                    h2 = (int)((double)w2 / ratio + 0.5);
                }
                if (w1 * h1 > w2 * h2) {
                    width = w1;
                    height = h1;
                } else {
                    width = w2;
                    height = h2;
                }
            } else {
                width = w1;
                height = h1;
            }
        }
        widthSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(widthSpec, heightSpec);
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (flag != 3 && !this.isShown()) {
            Log.i((String)this.TAG, (String)"Not Shown!");
            return false;
        }
        RotateAnimation animation = new RotateAnimation((float)offset, 0.0f, 1, 0.5f, 1, 0.5f);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        this.mHandler.post((Runnable)new RotateRunable((Animation)animation, (View)this, degree));
        this.mCurDegree = degree;
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        MotionEvent newEvent = ev;
        if (this.mTouchController != null) {
            newEvent = this.mTouchController.obtainTouchEvent(ev, this.getWidth(), this.getHeight(), this.mCurDegree);
        }
        if (this.mOnDispatchTouchEventListener != null) {
            this.mOnDispatchTouchEventListener.onDispatchTouchEvent((View)this, ev);
        }
        return super.dispatchTouchEvent(newEvent);
    }

    public void setOnDispatchTouchEventListener(TouchController.OnDispatchTouchEventListener listener) {
        this.mOnDispatchTouchEventListener = listener;
    }

    @Override
    public int getCurrentOrientationDegree() {
        return this.mCurDegree;
    }
}

