/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.tools;

import android.util.Log;

public class FrameHelper {
    private final String TAG = this.getClass().getSimpleName();
    private long mStartTime;
    private long mFrames;
    private boolean isShow = true;

    public FrameHelper() {
        this.reset();
    }

    public void printFPS() {
        if (this.isShow) {
            if (this.mStartTime == 0L) {
                this.mStartTime = System.currentTimeMillis();
                this.mFrames = 0L;
            } else {
                ++this.mFrames;
                if (this.mFrames >= 10L) {
                    Log.e((String)this.TAG, (String)("FPS = " + (int)(1000.0 * (double)this.mFrames / (double)(System.currentTimeMillis() - this.mStartTime))));
                    this.mStartTime = 0L;
                }
            }
        }
    }

    public void reset() {
        this.mStartTime = 0L;
        this.mFrames = 0L;
    }

    public void enable(boolean show) {
        if (this.isShow) {
            this.reset();
        }
        this.isShow = show;
    }
}

