/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.socket.Transfer;

import android.util.Log;
import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.network.socket.Data.AbsTransmitter;
import java.io.DataInputStream;
import java.io.File;
import java.net.Socket;

public class Receiver
extends AbsLoop {
    private String TAG = this.getClass().getSimpleName();
    private static final int BUFFER_LENGTH = 8192;
    private Socket mSocket;
    private DataInputStream mDataRead;
    private byte[] mBuffer = new byte[8192];
    private String mLocalDir;
    private OnReceiverListener mOnReceiverListener;

    public Receiver(String local_dir, Socket socket) {
        this.mLocalDir = local_dir;
        File file = new File(this.mLocalDir);
        file.mkdirs();
        this.mSocket = socket;
        this.mOnReceiverListener = null;
    }

    public void setOnReceiverListener(OnReceiverListener l) {
        this.mOnReceiverListener = l;
    }

    @Override
    public void setup() {
        try {
            this.mDataRead = new DataInputStream(this.mSocket.getInputStream());
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setup:" + e.getMessage()));
            if (this.mOnReceiverListener != null) {
                this.mOnReceiverListener.onException(3);
            }
            return;
        }
        if (this.mOnReceiverListener != null) {
            this.mOnReceiverListener.onReceiveInitial(this.mSocket, this.mDataRead);
        }
    }

    @Override
    public void loop() {
        block6: {
            try {
                if (this.mDataRead.available() <= 0) {
                    Receiver.sleep(1L);
                    return;
                }
                if (this.mOnReceiverListener != null) {
                    AbsTransmitter object = this.mOnReceiverListener.onReceiveType(this.mDataRead.readInt());
                    object.setOnReceiverListener(this.mOnReceiverListener);
                    int ex = object.recv(this.mDataRead, this.mBuffer);
                    if (ex != 0) {
                        this.mOnReceiverListener.onException(ex);
                    }
                } else {
                    Log.e((String)this.TAG, (String)"please set listener!");
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("loop:" + e.getMessage()));
                if (this.mOnReceiverListener == null) break block6;
                this.mOnReceiverListener.onException(4);
            }
        }
    }

    @Override
    public void over() {
        block4: {
            if (this.mOnReceiverListener != null) {
                this.mOnReceiverListener.onReceiveDestroy(this.mSocket);
            }
            try {
                if (this.mDataRead != null) {
                    this.mDataRead.close();
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("over:" + e.getMessage()));
                if (this.mOnReceiverListener == null) break block4;
                this.mOnReceiverListener.onException(5);
            }
        }
    }

    public static interface OnReceiverListener {
        public void onException(int var1);

        public AbsTransmitter onReceiveType(int var1);

        public void onReceiveProcess(AbsTransmitter var1, int var2, int var3);

        public void onReceiveInitial(Socket var1, DataInputStream var2);

        public void onReceiveDestroy(Socket var1);
    }
}

