/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.socket;

import com.guo.android_extend.network.socket.OnSocketListener;
import com.guo.android_extend.network.socket.SocketClient;
import com.guo.android_extend.network.socket.SocketServer;
import java.io.File;

public class SocketModule {
    private String TAG = this.getClass().getSimpleName();
    public static final int PORT = 4203;
    private String mLocalDir;
    private String mIP;
    private int mPort;
    private OnSocketListener mOnSocketListener;
    private SocketServer mSocketServer;
    private SocketClient mSocketClient;

    public SocketModule(String local_dir, int port) {
        File file = new File(local_dir);
        file.mkdirs();
        this.mLocalDir = local_dir;
        this.mOnSocketListener = null;
        this.mSocketServer = new SocketServer(this.mLocalDir, port);
        this.mSocketServer.setOnSocketListener(this.mOnSocketListener);
        this.mSocketServer.start();
        this.mSocketClient = null;
    }

    public SocketModule(String local_dir) {
        this(local_dir, 4203);
    }

    public void connect(String ip) {
        this.connect(ip, 4203);
    }

    public void connect(String ip, int port) {
        this.mIP = ip;
        this.mPort = port;
        if (this.mSocketClient != null) {
            this.mSocketClient.shutdown();
        }
        this.mSocketClient = new SocketClient(this.mLocalDir, ip, port);
        this.mSocketClient.setOnSocketListener(this.mOnSocketListener);
        this.mSocketClient.start();
    }

    public void disconnect() {
        if (this.mSocketClient != null) {
            this.mSocketClient.shutdown();
        }
        this.mSocketClient = null;
    }

    public boolean send(byte[] data, int length) {
        if (this.mSocketClient != null) {
            return this.mSocketClient.send(data, length);
        }
        return false;
    }

    public boolean send(String file) {
        if (this.mSocketClient != null) {
            return this.mSocketClient.send(file);
        }
        return false;
    }

    public void setOnSocketListener(OnSocketListener sl) {
        this.mOnSocketListener = sl;
        if (this.mSocketServer != null) {
            this.mSocketServer.setOnSocketListener(this.mOnSocketListener);
        }
        if (this.mSocketClient != null) {
            this.mSocketClient.setOnSocketListener(this.mOnSocketListener);
        }
    }

    public void destroy() {
        if (this.mSocketServer != null) {
            this.mSocketServer.shutdown();
        }
        if (this.mSocketClient != null) {
            this.mSocketClient.shutdown();
        }
    }
}

