/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.socket;

import android.util.Log;
import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.network.socket.Data.AbsTransmitter;
import com.guo.android_extend.network.socket.Data.TransmitByte;
import com.guo.android_extend.network.socket.Data.TransmitFile;
import com.guo.android_extend.network.socket.OnSocketListener;
import com.guo.android_extend.network.socket.Transfer.Receiver;
import com.guo.android_extend.network.socket.Transfer.Sender;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public class SocketClient
extends AbsLoop
implements Sender.OnSenderListener,
Receiver.OnReceiverListener {
    private String TAG = this.getClass().getSimpleName();
    OnSocketListener mOnSocketListener;
    Sender mSender = null;
    Receiver mReceiver;
    String mLocalDir;
    Socket mSocket = null;
    String mIP;
    int mPort;
    int mSendPercent;
    int mReceivePercent;

    public SocketClient(String localdir) {
        this.mIP = null;
        this.mPort = 0;
        this.mLocalDir = localdir;
    }

    public SocketClient(String localdir, String ip, int port) {
        this.mIP = ip;
        this.mPort = port;
        this.mLocalDir = localdir;
    }

    public void setOnSocketListener(OnSocketListener mOnSocketListener) {
        this.mOnSocketListener = mOnSocketListener;
    }

    public void connect(String ip) {
        this.connect(ip, 4203);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String ip, int port) {
        this.mIP = ip;
        this.mPort = port;
        if (!this.isAlive()) {
            this.start();
        }
        this.disconnect();
        SocketClient socketClient = this;
        synchronized (socketClient) {
            this.notify();
        }
    }

    public void disconnect() {
        try {
            if (this.mSender != null) {
                this.mSender.shutdown();
            }
            if (this.mReceiver != null) {
                this.mReceiver.shutdown();
            }
            if (this.mSocket != null && !this.mSocket.isClosed()) {
                this.mSocket.close();
            }
            this.mSocket = null;
            this.mSender = null;
            this.mReceiver = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean send(AbsTransmitter obj) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(obj);
    }

    public boolean send(byte[] data, int length) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(new TransmitByte(data, length));
    }

    public boolean send(String file) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(new TransmitFile(file));
    }

    @Override
    public void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop() {
        block9: {
            try {
                Log.d((String)this.TAG, (String)"wait for connect...");
                if (this.mSocket == null) {
                    SocketClient socketClient = this;
                    synchronized (socketClient) {
                        this.wait(1000L);
                    }
                    this.mSocket = new Socket(this.mIP, this.mPort);
                    Log.d((String)this.TAG, (String)("socket connected: " + this.mSocket.getRemoteSocketAddress()));
                    this.mSender = new Sender(this.mSocket);
                    this.mSender.setOnSenderListener(this);
                    this.mSender.start();
                    this.mReceiver = new Receiver(this.mLocalDir, this.mSocket);
                    this.mReceiver.setOnReceiverListener(this);
                    this.mReceiver.start();
                    break block9;
                }
                SocketClient socketClient = this;
                synchronized (socketClient) {
                    this.wait();
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("run:" + e.getCause().getMessage()));
                this.onException(2);
            }
        }
    }

    @Override
    public void over() {
    }

    @Override
    public void break_loop() {
        super.break_loop();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(int error) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketException(error);
        }
        this.disconnect();
        SocketClient socketClient = this;
        synchronized (socketClient) {
            this.notify();
        }
    }

    @Override
    public AbsTransmitter onReceiveType(int type) {
        if (type == 1911488512) {
            return new TransmitByte();
        }
        if (type == 1894711296) {
            return new TransmitFile(this.mLocalDir, null);
        }
        return null;
    }

    @Override
    public void onReceiveProcess(AbsTransmitter obj, int cur, int total) {
        int percent;
        if (this.mOnSocketListener != null && this.mReceivePercent != (percent = cur / total * 100)) {
            this.mReceivePercent = percent;
            this.mOnSocketListener.onReceiveProcess(obj, percent);
            if (cur == total) {
                this.mOnSocketListener.onReceived(obj);
                this.mReceivePercent = 0;
            }
        }
    }

    @Override
    public void onReceiveInitial(Socket socket, DataInputStream dis) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1000);
        }
    }

    @Override
    public void onReceiveDestroy(Socket socket) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1002);
        }
    }

    @Override
    public void onSendProcess(AbsTransmitter obj, int cur, int total) {
        int percent;
        if (this.mOnSocketListener != null && this.mSendPercent != (percent = cur / total * 100)) {
            this.mSendPercent = percent;
            this.mOnSocketListener.onSendProcess(obj, percent);
            if (cur == total) {
                this.mOnSocketListener.onSended(obj);
                this.mSendPercent = 0;
            }
        }
    }

    @Override
    public void onSendInitial(Socket socket, DataOutputStream dos) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1001);
        }
    }

    @Override
    public void onSendDestroy(Socket socket) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1003);
        }
    }
}

