/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.http;

import com.guo.android_extend.network.NetWorkFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class Downloader<T>
extends NetWorkFile
implements Runnable {
    private T mID;
    private OnMonitoring mOnMonitoring;
    public static int DOWNLOAD_OK = 0;
    public static int DOWNLOAD_ERR_NET = 1;
    public static int DOWNLOAD_ERR_IO = 2;
    public static int DOWNLOAD_ERR_FILE = 3;
    public static int DOWNLOAD_ERR_USER = 4;

    protected Downloader(String mLocalDir, String mUrl, T mID) {
        super(mLocalDir, mUrl);
        this.mID = mID;
    }

    public T getID() {
        return this.mID;
    }

    public final void setOnMonitoring(OnMonitoring mOnMonitoring) {
        this.mOnMonitoring = mOnMonitoring;
    }

    public void onTaskOver(Downloader<?> context, int error) {
        if (this.mOnMonitoring != null) {
            this.mOnMonitoring.onFinish(this, true);
        }
    }

    public boolean onDownloadFinish(Downloader<?> context, String cache) {
        return true;
    }

    public abstract void onDownloadUpdate(Downloader<?> var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String cache = this.createCacheFile();
        try {
            URL url = new URL(this.mUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setInstanceFollowRedirects(true);
            int total = conn.getContentLength();
            int cur = 0;
            int pre = 0;
            InputStream is = conn.getInputStream();
            File file = new File(cache);
            FileOutputStream os = new FileOutputStream(file);
            byte[] bytes = new byte[0x100000];
            int length = 0;
            try {
                while ((length = is.read(bytes, 0, 0x100000)) != -1) {
                    ((OutputStream)os).write(bytes, 0, length);
                    if ((cur += length) * 100 > (pre + 5) * total) {
                        pre = cur * 100 / total;
                        this.onDownloadUpdate(this, pre >= 100 ? 100 : pre);
                    }
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onTaskOver(this, DOWNLOAD_ERR_IO);
                return;
            }
            finally {
                ((OutputStream)os).close();
                is.close();
                conn.disconnect();
            }
            if (!this.onDownloadFinish(this, cache)) {
                this.onTaskOver(this, DOWNLOAD_ERR_USER);
            } else if (!file.renameTo(new File(this.getLocalFile()))) {
                this.onTaskOver(this, DOWNLOAD_ERR_FILE);
            } else {
                this.onTaskOver(this, DOWNLOAD_OK);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.onTaskOver(this, DOWNLOAD_ERR_NET);
        }
    }

    protected static interface OnMonitoring {
        public void onFinish(Downloader<?> var1, boolean var2);
    }
}

