/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.device;

public class Video {
    private final String TAG = this.getClass().getSimpleName();
    private long mHandle;

    private native long initVideo(int var1);

    private native int setVideo(long var1, int var3, int var4, int var5);

    private native int uninitVideo(long var1);

    private native int readData(long var1, byte[] var3, int var4);

    public Video(int port) throws Exception {
        this.mHandle = this.initVideo(port);
        if (this.mHandle == 0L) {
            throw new RuntimeException("Open Video device error!");
        }
    }

    public void setVideo(int width, int height, int format) {
        if (this.mHandle != 0L) {
            this.setVideo(this.mHandle, width, height, format);
        }
    }

    public void destroy() {
        if (this.mHandle != 0L) {
            this.uninitVideo(this.mHandle);
        }
    }

    public int readFrame(byte[] data) {
        if (this.mHandle != 0L) {
            return this.readData(this.mHandle, data, data.length);
        }
        return 0;
    }

    static {
        System.loadLibrary("video");
    }
}

