/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.cache;

import android.graphics.Bitmap;

public class BitmapStructure {
    int mWidth = 0;
    int mHeight = 0;
    int mFormat = -1;

    public Bitmap.Config getConfig() {
        return BitmapStructure.NativeFormat2Config(this.mFormat);
    }

    public void setConfig(Bitmap.Config config) {
        this.mFormat = BitmapStructure.Config2NativeFormat(config);
    }

    public void setInfo(int width, int height, int format) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
    }

    public void setInfo(int width, int height, Bitmap.Config config) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = BitmapStructure.Config2NativeFormat(config);
    }

    public Bitmap createBitmap() {
        return Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)this.getConfig());
    }

    public String toString() {
        return super.toString() + "W = " + this.mWidth + ", H = " + this.mHeight + ", F = " + this.mFormat;
    }

    public static int Config2NativeFormat(Bitmap.Config config) {
        switch (config) {
            case ARGB_8888: {
                return 1;
            }
            case RGB_565: {
                return 4;
            }
            case ARGB_4444: {
                return 7;
            }
            case ALPHA_8: {
                return 8;
            }
        }
        return -1;
    }

    public static Bitmap.Config NativeFormat2Config(int format) {
        switch (format) {
            case 1: {
                return Bitmap.Config.ARGB_8888;
            }
            case 4: {
                return Bitmap.Config.RGB_565;
            }
            case 7: {
                return Bitmap.Config.ARGB_4444;
            }
            case 8: {
                return Bitmap.Config.ALPHA_8;
            }
        }
        return null;
    }
}

