/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.cache;

import android.os.Handler;
import android.util.Log;
import com.guo.android_extend.cache.BitmapCache;
import com.guo.android_extend.cache.BitmapMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class BitmapMonitorThread<K, V>
extends Thread
implements BitmapMonitor.OnMonitoring<K, V> {
    private final String TAG = this.getClass().toString();
    private HashMap<K, BitmapMonitor<K, V>> mWidgetMap = new LinkedHashMap<K, BitmapMonitor<K, V>>();
    private volatile Thread mBlinker;
    private Handler mHandler;
    private BitmapCache<V> mBitmapCache = new BitmapCache(32, true);
    private boolean mPause;

    public BitmapMonitorThread(Handler handler) {
        this.mHandler = handler;
        this.mBlinker = this;
        this.mPause = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postLoadBitmap(BitmapMonitor<K, V> monitor) {
        monitor.setOnMonitoring(this);
        Object object = this.mWidgetMap;
        synchronized (object) {
            this.mWidgetMap.put(monitor.mView, monitor);
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public boolean pause(boolean sync) {
        this.mPause = true;
        try {
            if (sync) {
                while (this.mPause) {
                    BitmapMonitorThread.sleep(10L);
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<K, BitmapMonitor<K, V>> hashMap = this.mWidgetMap;
        synchronized (hashMap) {
            this.mWidgetMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.mBlinker = null;
        try {
            BitmapMonitorThread bitmapMonitorThread = this;
            synchronized (bitmapMonitorThread) {
                this.notify();
            }
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        BitmapMonitor<K, V> monitor = null;
        while (this.mBlinker == thisThread) {
            monitor = null;
            Object object = this.mWidgetMap;
            synchronized (object) {
                Iterator<K> iterator;
                if (!this.mWidgetMap.isEmpty() && (iterator = this.mWidgetMap.keySet().iterator()).hasNext()) {
                    monitor = this.mWidgetMap.remove(iterator.next());
                }
            }
            if (monitor == null || this.mPause) {
                object = this;
                synchronized (object) {
                    try {
                        if (this.mPause) {
                            this.mPause = false;
                        }
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            try {
                monitor.mBitmap = this.mBitmapCache.getBitmap(monitor.getBitmapID());
                if (monitor.mBitmap != null) continue;
                monitor.mBitmap = monitor.decodeImage();
                this.mBitmapCache.putBitmap(monitor.getBitmapID(), monitor.mBitmap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mHandler.post(monitor);
            }
        }
        this.mBitmapCache.destroy();
        Log.d((String)this.TAG, (String)"Thread Over");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdated(BitmapMonitor<K, V> monitor) {
        HashMap<K, BitmapMonitor<K, V>> hashMap = this.mWidgetMap;
        synchronized (hashMap) {
            if (!this.mWidgetMap.containsKey(monitor.mView)) {
                return false;
            }
            if (this.mWidgetMap.get(monitor.mView).mBitmapID.equals(monitor.mBitmapID)) {
                this.mWidgetMap.remove(monitor.mView);
                return false;
            }
        }
        return true;
    }
}

