/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageButton;
import com.guo.android_extend.widget.ExtOrientationDetector;
import com.guo.android_extend.widget.RotateRunable;

public class ExtImageButton
extends ImageButton
implements ExtOrientationDetector.OnOrientationListener,
Animation.AnimationListener {
    private final String TAG = this.getClass().toString();
    private Handler mHandler;
    private final int ANIMATION_TIME = 300;
    private int mCurDegree;
    private float scaleX;
    private float scaleY;

    public ExtImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.preCreate(context);
    }

    public ExtImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.preCreate(context);
    }

    public ExtImageButton(Context context) {
        super(context);
        this.preCreate(context);
    }

    private void preCreate(Context context) {
        this.mHandler = new Handler();
        this.mCurDegree = 0;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (flag != 3 && !this.isShown()) {
            Log.i((String)this.TAG, (String)"Not Shown!");
            return false;
        }
        RotateAnimation animation = new RotateAnimation((float)offset, 0.0f, 1, 0.5f, 1, 0.5f);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        this.mHandler.post((Runnable)new RotateRunable((Animation)animation, (View)this, degree));
        this.mCurDegree = degree;
        return true;
    }

    @Override
    public int getCurrentOrientationDegree() {
        return this.mCurDegree;
    }

    public void onAnimationStart(Animation animation) {
        this.setVisibility(8);
        this.setEnabled(false);
    }

    public void onAnimationEnd(Animation animation) {
        this.setVisibility(0);
        this.setEnabled(true);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.scale(this.scaleX, this.scaleY, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        canvas.rotate((float)(-this.mCurDegree), (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        super.onDraw(canvas);
        canvas.restore();
    }

    public void setScale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }
}

