/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.socket;

import android.util.Log;
import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.network.socket.Data.AbsTransmitter;
import com.guo.android_extend.network.socket.Data.TransmitByte;
import com.guo.android_extend.network.socket.Data.TransmitFile;
import com.guo.android_extend.network.socket.OnSocketListener;
import com.guo.android_extend.network.socket.Transfer.Receiver;
import com.guo.android_extend.network.socket.Transfer.Sender;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketServer
extends AbsLoop
implements Receiver.OnReceiverListener,
Sender.OnSenderListener {
    private String TAG = this.getClass().getSimpleName();
    OnSocketListener mOnSocketListener;
    Receiver mReceiver = null;
    String mLocalDir;
    Sender mSender;
    Socket mSocket = null;
    ServerSocket mServerSocket;
    int mPort;
    int mReceivePercent;
    int mSendPercent;

    public SocketServer(String localdir) {
        this.mLocalDir = localdir;
        this.mPort = 4203;
        try {
            this.mServerSocket = new ServerSocket(this.mPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SocketServer(String localdir, int port) {
        this.mLocalDir = localdir;
        this.mPort = port;
        try {
            this.mServerSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOnSocketListener(OnSocketListener mOnSocketListener) {
        this.mOnSocketListener = mOnSocketListener;
    }

    public boolean send(AbsTransmitter obj) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(obj);
    }

    public boolean send(byte[] data, int length) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(new TransmitByte(data, length));
    }

    public boolean send(String file) {
        if (this.mSender == null) {
            return false;
        }
        return this.mSender.post(new TransmitFile(file));
    }

    @Override
    public void setup() {
    }

    @Override
    public void loop() {
        try {
            Log.d((String)this.TAG, (String)"wait for connect...");
            this.mSocket = this.mServerSocket.accept();
            if (this.mSocket == null) {
                throw new RuntimeException("server closed!");
            }
            Log.d((String)this.TAG, (String)("socket connected: " + this.mSocket.getRemoteSocketAddress()));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("run:" + e.getMessage()));
            if (this.mOnSocketListener != null) {
                this.mOnSocketListener.onSocketEvent(this.mSocket, 1004);
            }
            return;
        }
        try {
            this.mReceiver = new Receiver(this.mLocalDir, this.mSocket);
            this.mReceiver.setOnReceiverListener(this);
            this.mReceiver.start();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("run:" + e.getMessage()));
            this.onException(2);
        }
        try {
            this.mSender = new Sender(this.mSocket);
            this.mSender.setOnSenderListener(this);
            this.mSender.start();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("run:" + e.getMessage()));
            this.onException(2);
        }
    }

    @Override
    public void over() {
    }

    @Override
    public void break_loop() {
        super.break_loop();
        try {
            if (this.mReceiver != null) {
                this.mReceiver.shutdown();
            }
            if (this.mSocket != null && !this.mSocket.isClosed()) {
                this.mSocket.close();
            }
            this.mServerSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onException(int error) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketException(error);
        }
        this.mSocket = null;
        if (this.mReceiver != null) {
            this.mReceiver.shutdown();
            this.mReceiver = null;
        }
        if (this.mSender != null) {
            this.mSender.shutdown();
            this.mSender = null;
        }
    }

    @Override
    public AbsTransmitter onReceiveType(int type) {
        if (type == 1911488512) {
            return new TransmitByte();
        }
        if (type == 1894711296) {
            return new TransmitFile(this.mLocalDir, null);
        }
        return null;
    }

    @Override
    public void onSendProcess(AbsTransmitter obj, int cur, int total) {
        int percent;
        if (this.mOnSocketListener != null && this.mSendPercent != (percent = cur / total * 100)) {
            this.mSendPercent = percent;
            this.mOnSocketListener.onSendProcess(obj, percent);
            if (cur == total) {
                this.mOnSocketListener.onSended(obj);
                this.mSendPercent = 0;
            }
        }
    }

    @Override
    public void onSendInitial(Socket socket, DataOutputStream dos) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1001);
        }
    }

    @Override
    public void onSendDestroy(Socket socket) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1003);
        }
    }

    @Override
    public void onReceiveProcess(AbsTransmitter obj, int cur, int total) {
        int percent;
        if (this.mOnSocketListener != null && this.mReceivePercent != (percent = cur / total * 100)) {
            this.mReceivePercent = percent;
            this.mOnSocketListener.onReceiveProcess(obj, percent);
            if (cur == total) {
                this.mOnSocketListener.onReceived(obj);
                this.mReceivePercent = 0;
            }
        }
    }

    @Override
    public void onReceiveInitial(Socket socket, DataInputStream dis) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1000);
        }
    }

    @Override
    public void onReceiveDestroy(Socket socket) {
        if (this.mOnSocketListener != null) {
            this.mOnSocketListener.onSocketEvent(socket, 1002);
        }
    }
}

