/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.socket.Data;

import android.util.Log;
import com.guo.android_extend.java.ExtByteArrayOutputStream;
import com.guo.android_extend.network.socket.Data.AbsTransmitter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransmitByte
extends AbsTransmitter {
    private String TAG = this.getClass().getSimpleName();
    protected byte[] mData;
    protected int mLength;

    public TransmitByte() {
        super(1911488512);
        this.mData = null;
        this.mLength = 0;
    }

    public TransmitByte(byte[] data, int length) {
        super(1911488512);
        if (length > 0x1000000) {
            throw new RuntimeException("byte data length is bigger than 16M");
        }
        this.mLength = length;
        this.mData = new byte[this.mLength + 8];
        System.arraycopy(TransmitByte.int_to_bytes_big(this.getType()), 0, this.mData, 0, 4);
        System.arraycopy(TransmitByte.int_to_bytes_big(this.mLength), 0, this.mData, 4, 4);
        System.arraycopy(data, 0, this.mData, 8, this.mLength);
        System.arraycopy(TransmitByte.int_to_bytes_big(-354680832), 0, this.mData, 8 + this.mLength, 4);
    }

    @Override
    public String getName() {
        return "byte";
    }

    public byte[] getData() {
        return this.mData;
    }

    @Override
    public int send(DataOutputStream stream, byte[] mBuffer) {
        int ret = 0;
        DataInputStream input = this.getDataInputStream();
        if (input == null) {
            Log.e((String)this.TAG, (String)"loop: Bad object!");
            return 6;
        }
        try {
            int read = 0;
            for (int size = 0; size < this.mData.length; size += read) {
                read = input.read(mBuffer);
                stream.write(mBuffer, 0, read);
                if (this.mOnSenderListener == null) continue;
                this.mOnSenderListener.onSendProcess(this, size + read, this.mData.length);
            }
            stream.flush();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("loop:" + e.getMessage()));
            ret = 4;
        }
        try {
            input.close();
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("loop:" + e.getMessage()));
            ret = 7;
        }
        return ret;
    }

    @Override
    public int recv(DataInputStream stream, byte[] mBuffer) {
        block5: {
            try {
                this.mLength = stream.readInt();
                DataOutputStream output = this.getDataOutputStream();
                int read = 0;
                for (int size = 0; size < this.mLength; size += read) {
                    read = stream.read(mBuffer, 0, Math.min(this.mLength - size, mBuffer.length));
                    output.write(mBuffer, 0, read);
                    if (this.mOnReceiverListener == null) continue;
                    this.mOnReceiverListener.onReceiveProcess(this, size, this.mLength);
                }
                if (stream.readInt() != -354680832) {
                    throw new Exception("received end code error!");
                }
                output.flush();
                output.close();
                if (this.mOnReceiverListener != null) {
                    this.mOnReceiverListener.onReceiveProcess(this, this.mLength, this.mLength);
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("loop:" + e.getMessage()));
                if (this.mOnReceiverListener == null) break block5;
                this.mOnReceiverListener.onException(7);
            }
        }
        return 0;
    }

    @Override
    public DataInputStream getDataInputStream() {
        return new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(this.mData, 0, this.mData.length)));
    }

    @Override
    public DataOutputStream getDataOutputStream() {
        ExtByteArrayOutputStream out = new ExtByteArrayOutputStream(this.mLength);
        this.mData = out.getByteArray();
        return new DataOutputStream(new BufferedOutputStream(out));
    }
}

