/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.http;

import android.util.Log;
import com.guo.android_extend.network.http.Downloader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DownloaderManager<T>
implements Downloader.OnMonitoring {
    private String TAG = this.getClass().getSimpleName();
    private ExecutorService mThreadPool;
    private int mMaxTask;
    private List<T> mDataPool = new LinkedList<T>();

    public DownloaderManager() {
        this(5);
    }

    public DownloaderManager(int maxTask) {
        this.mMaxTask = maxTask;
        this.mThreadPool = Executors.newFixedThreadPool(this.mMaxTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postDownload(Downloader<T> downloader) {
        if (this.mThreadPool.isShutdown()) {
            Log.e((String)this.TAG, (String)"already shutdown");
            return false;
        }
        List<T> list = this.mDataPool;
        synchronized (list) {
            if (!this.mDataPool.contains(downloader.getID())) {
                downloader.setOnMonitoring(this);
                this.mDataPool.add(downloader.getID());
                this.mThreadPool.execute(downloader);
                return true;
            }
        }
        return false;
    }

    public void shutdown() {
        try {
            this.mDataPool.clear();
            this.mThreadPool.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinish(Downloader<?> downloader, boolean isSuccess) {
        List<T> list = this.mDataPool;
        synchronized (list) {
            this.mDataPool.remove(downloader.getID());
        }
    }
}

