/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.device;

import com.guo.android_extend.device.Serial;
import com.guo.android_extend.device.SerialInterface;
import com.guo.android_extend.device.SerialListener;
import com.guo.android_extend.java.AbsLoop;

public class SerialClient
extends AbsLoop
implements SerialInterface {
    private final String TAG = this.getClass().toString();
    public static final int SERIAL_CODE = 16384;
    public static final int RECEIVE_MSG = 16385;
    private Serial mPort;
    private SerialListener mSerialListener;

    public SerialClient(int port, int type) {
        this(port, type, 115200, 1, 255);
    }

    public SerialClient(int port, int type, int rate) {
        this(port, type, rate, 1, 255);
    }

    public SerialClient(String dev, int rate, int vtime, int vmin) {
        try {
            this.mPort = new Serial(dev);
            this.mPort.setConfig(rate, 8, (byte)78, 1, vtime, vmin);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Create SerialClient ERROR");
        }
        this.mSerialListener = null;
    }

    public SerialClient(int port, int type, int rate, int vtime, int vmin) {
        try {
            this.mPort = new Serial(port, type);
            this.mPort.setConfig(rate, 8, (byte)78, 1, vtime, vmin);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Create SerialClient ERROR");
        }
        this.mSerialListener = null;
    }

    @Override
    public void setup() {
    }

    @Override
    public void loop() {
        byte[] data = this.mPort.receive();
        if (data != null && this.mSerialListener != null) {
            this.mSerialListener.onSerialReceivce(this.mPort, data);
        }
    }

    @Override
    public void over() {
        this.mPort.destroy();
    }

    public boolean sendData(String data) {
        return this.mPort.send(data.getBytes());
    }

    @Override
    public boolean sendData(byte[] data) {
        return this.mPort.send(data);
    }

    @Override
    public void setSerialListener(SerialListener lis) {
        this.mSerialListener = lis;
    }
}

