/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CSVRecordTest {
    private Map<String, Integer> headerMap;
    private CSVRecord record;
    private CSVRecord recordWithHeader;
    private String[] values;

    @BeforeEach
    public void setUp() throws Exception {
        this.values = new String[]{"A", "B", "C"};
        String rowData = StringUtils.join((Object[])this.values, (char)',');
        try (CSVParser parser = CSVFormat.DEFAULT.parse((Reader)new StringReader(rowData));){
            this.record = (CSVRecord)parser.iterator().next();
        }
        String[] headers = new String[]{"first", "second", "third"};
        try (CSVParser parser = CSVFormat.DEFAULT.withHeader(headers).parse((Reader)new StringReader(rowData));){
            this.recordWithHeader = (CSVRecord)parser.iterator().next();
            this.headerMap = parser.getHeaderMap();
        }
    }

    @Test
    public void testGetInt() {
        Assertions.assertEquals((Object)this.values[0], (Object)this.record.get(0));
        Assertions.assertEquals((Object)this.values[1], (Object)this.record.get(1));
        Assertions.assertEquals((Object)this.values[2], (Object)this.record.get(2));
    }

    @Test
    public void testGetString() {
        Assertions.assertEquals((Object)this.values[0], (Object)this.recordWithHeader.get("first"));
        Assertions.assertEquals((Object)this.values[1], (Object)this.recordWithHeader.get("second"));
        Assertions.assertEquals((Object)this.values[2], (Object)this.recordWithHeader.get("third"));
    }

    @Test
    public void testGetStringInconsistentRecord() {
        this.headerMap.put("fourth", 4);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get("fourth"));
    }

    @Test
    public void testGetStringNoHeader() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.record.get("first"));
    }

    @Test
    public void testGetUnmappedEnum() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get((Enum)EnumFixture.UNKNOWN_COLUMN));
    }

    @Test
    public void testGetNullEnum() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get((Enum)null));
    }

    @Test
    public void testGetUnmappedName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertNull((Object)this.recordWithHeader.get("fourth")));
    }

    @Test
    public void testGetUnmappedNegativeInt() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.recordWithHeader.get(Integer.MIN_VALUE));
    }

    @Test
    public void testGetUnmappedPositiveInt() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.recordWithHeader.get(Integer.MAX_VALUE));
    }

    @Test
    public void testIsConsistent() {
        Assertions.assertTrue((boolean)this.record.isConsistent());
        Assertions.assertTrue((boolean)this.recordWithHeader.isConsistent());
        Map map = this.recordWithHeader.getParser().getHeaderMap();
        map.put("fourth", 4);
        Assertions.assertTrue((boolean)this.recordWithHeader.isConsistent());
    }

    @Test
    public void testIsInconsistent() throws IOException {
        String[] headers = new String[]{"first", "second", "third"};
        String rowData = StringUtils.join((Object[])this.values, (char)',');
        try (CSVParser parser = CSVFormat.DEFAULT.withHeader(headers).parse((Reader)new StringReader(rowData));){
            Map map = parser.getHeaderMapRaw();
            CSVRecord record1 = (CSVRecord)parser.iterator().next();
            map.put("fourth", 4);
            Assertions.assertFalse((boolean)record1.isConsistent());
        }
    }

    @Test
    public void testIsMapped() {
        Assertions.assertFalse((boolean)this.record.isMapped("first"));
        Assertions.assertTrue((boolean)this.recordWithHeader.isMapped("first"));
        Assertions.assertFalse((boolean)this.recordWithHeader.isMapped("fourth"));
    }

    @Test
    public void testIsSetInt() {
        Assertions.assertFalse((boolean)this.record.isSet(-1));
        Assertions.assertTrue((boolean)this.record.isSet(0));
        Assertions.assertTrue((boolean)this.record.isSet(2));
        Assertions.assertFalse((boolean)this.record.isSet(3));
        Assertions.assertTrue((boolean)this.recordWithHeader.isSet(1));
        Assertions.assertFalse((boolean)this.recordWithHeader.isSet(1000));
    }

    @Test
    public void testIsSetString() {
        Assertions.assertFalse((boolean)this.record.isSet("first"));
        Assertions.assertTrue((boolean)this.recordWithHeader.isSet("first"));
        Assertions.assertFalse((boolean)this.recordWithHeader.isSet("fourth"));
    }

    @Test
    public void testIterator() {
        int i = 0;
        for (String value : this.record) {
            Assertions.assertEquals((Object)this.values[i], (Object)value);
            ++i;
        }
    }

    @Test
    public void testPutInMap() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        this.recordWithHeader.putIn(map);
        this.validateMap(map, false);
        TreeMap map2 = (TreeMap)this.recordWithHeader.putIn(new TreeMap());
        this.validateMap(map2, false);
    }

    @Test
    public void testRemoveAndAddColumns() throws IOException {
        try (CSVPrinter printer = new CSVPrinter((Appendable)new StringBuilder(), CSVFormat.DEFAULT);){
            Map map = this.recordWithHeader.toMap();
            map.remove("OldColumn");
            map.put("ZColumn", "NewValue");
            ArrayList list = new ArrayList(map.values());
            Collections.sort(list);
            printer.printRecord(list);
            Assertions.assertEquals((Object)("A,B,C,NewValue" + CSVFormat.DEFAULT.getRecordSeparator()), (Object)printer.getOut().toString());
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        CSVRecord shortRec;
        try (CSVParser parser = CSVParser.parse((String)"A,B\n#my comment\nOne,Two", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]).withCommentMarker('#'));){
            shortRec = (CSVRecord)parser.iterator().next();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(shortRec);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(in);){
            Object object = ois.readObject();
            Assertions.assertTrue((boolean)(object instanceof CSVRecord));
            CSVRecord rec = (CSVRecord)object;
            Assertions.assertEquals((long)1L, (long)rec.getRecordNumber());
            Assertions.assertEquals((Object)"One", (Object)rec.get(0));
            Assertions.assertEquals((Object)"Two", (Object)rec.get(1));
            Assertions.assertEquals((int)2, (int)rec.size());
            Assertions.assertEquals((long)shortRec.getCharacterPosition(), (long)rec.getCharacterPosition());
            Assertions.assertEquals((Object)"my comment", (Object)rec.getComment());
            Assertions.assertNull((Object)rec.getParser());
            Assertions.assertTrue((boolean)rec.isConsistent());
            Assertions.assertFalse((boolean)rec.isMapped("A"));
            Assertions.assertFalse((boolean)rec.isSet("A"));
            Assertions.assertEquals((int)0, (int)rec.toMap().size());
            try {
                rec.get("A");
                Assertions.fail((String)"Access by name is not expected after deserialisation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testToMap() {
        Map map = this.recordWithHeader.toMap();
        this.validateMap(map, true);
    }

    @Test
    public void testToMapWithNoHeader() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.newFormat((char)','));){
            CSVRecord shortRec = (CSVRecord)parser.iterator().next();
            Map map = shortRec.toMap();
            Assertions.assertNotNull((Object)map, (String)"Map is not null.");
            Assertions.assertTrue((boolean)map.isEmpty(), (String)"Map is empty.");
        }
    }

    @Test
    public void testToMapWithShortRecord() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));){
            CSVRecord shortRec = (CSVRecord)parser.iterator().next();
            shortRec.toMap();
        }
    }

    private void validateMap(Map<String, String> map, boolean allowsNulls) {
        Assertions.assertTrue((boolean)map.containsKey("first"));
        Assertions.assertTrue((boolean)map.containsKey("second"));
        Assertions.assertTrue((boolean)map.containsKey("third"));
        Assertions.assertFalse((boolean)map.containsKey("fourth"));
        if (allowsNulls) {
            Assertions.assertFalse((boolean)map.containsKey(null));
        }
        Assertions.assertEquals((Object)"A", (Object)map.get("first"));
        Assertions.assertEquals((Object)"B", (Object)map.get("second"));
        Assertions.assertEquals((Object)"C", (Object)map.get("third"));
        Assertions.assertEquals(null, (Object)map.get("fourth"));
    }

    private static enum EnumFixture {
        UNKNOWN_COLUMN;

    }
}

