/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CSVFileParserTest {
    private static final File BASE = new File("src/test/resources/CSVFileParser");

    private String readTestData(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && line.startsWith("#")) {
        }
        return line;
    }

    public static Stream<File> generateData() {
        FilenameFilter fileNameFilter = (dir, name) -> name.startsWith("test") && name.endsWith(".txt");
        File[] files = BASE.listFiles(fileNameFilter);
        if (files != null) {
            return Arrays.stream(files);
        }
        return Stream.empty();
    }

    @ParameterizedTest
    @MethodSource(value={"generateData"})
    public void testCSVFile(File testFile) throws Exception {
        try (FileReader fr = new FileReader(testFile);
             BufferedReader testData = new BufferedReader(fr);){
            String line = this.readTestData(testData);
            Assertions.assertNotNull((Object)"file must contain config line", (String)line);
            String[] split = line.split(" ");
            Assertions.assertTrue((split.length >= 1 ? 1 : 0) != 0, (String)(testFile.getName() + " require 1 param"));
            CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
            boolean checkComments = false;
            for (int i = 1; i < split.length; ++i) {
                String option = split[i];
                String[] option_parts = option.split("=", 2);
                if ("IgnoreEmpty".equalsIgnoreCase(option_parts[0])) {
                    format = format.withIgnoreEmptyLines(Boolean.parseBoolean(option_parts[1]));
                    continue;
                }
                if ("IgnoreSpaces".equalsIgnoreCase(option_parts[0])) {
                    format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(option_parts[1]));
                    continue;
                }
                if ("CommentStart".equalsIgnoreCase(option_parts[0])) {
                    format = format.withCommentMarker(option_parts[1].charAt(0));
                    continue;
                }
                if ("CheckComments".equalsIgnoreCase(option_parts[0])) {
                    checkComments = true;
                    continue;
                }
                Assertions.fail((String)(testFile.getName() + " unexpected option: " + option));
            }
            line = this.readTestData(testData);
            Assertions.assertEquals((Object)line, (Object)format.toString(), (String)(testFile.getName() + " Expected format "));
            try (CSVParser parser = CSVParser.parse((File)new File(BASE, split[0]), (Charset)Charset.defaultCharset(), (CSVFormat)format);){
                for (CSVRecord record : parser) {
                    String comment;
                    String parsed = Arrays.toString(record.values());
                    if (checkComments && (comment = record.getComment().replace("\n", "\\n")) != null) {
                        parsed = parsed + "#" + comment;
                    }
                    int count = record.size();
                    Assertions.assertEquals((Object)this.readTestData(testData), (Object)(count + ":" + parsed), (String)testFile.getName());
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"generateData"})
    public void testCSVUrl(File testFile) throws Exception {
        try (FileReader fr = new FileReader(testFile);
             BufferedReader testData = new BufferedReader(fr);){
            String line = this.readTestData(testData);
            Assertions.assertNotNull((Object)"file must contain config line", (String)line);
            String[] split = line.split(" ");
            Assertions.assertTrue((split.length >= 1 ? 1 : 0) != 0, (String)(testFile.getName() + " require 1 param"));
            CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
            boolean checkComments = false;
            for (int i = 1; i < split.length; ++i) {
                String option = split[i];
                String[] option_parts = option.split("=", 2);
                if ("IgnoreEmpty".equalsIgnoreCase(option_parts[0])) {
                    format = format.withIgnoreEmptyLines(Boolean.parseBoolean(option_parts[1]));
                    continue;
                }
                if ("IgnoreSpaces".equalsIgnoreCase(option_parts[0])) {
                    format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(option_parts[1]));
                    continue;
                }
                if ("CommentStart".equalsIgnoreCase(option_parts[0])) {
                    format = format.withCommentMarker(option_parts[1].charAt(0));
                    continue;
                }
                if ("CheckComments".equalsIgnoreCase(option_parts[0])) {
                    checkComments = true;
                    continue;
                }
                Assertions.fail((String)(testFile.getName() + " unexpected option: " + option));
            }
            line = this.readTestData(testData);
            Assertions.assertEquals((Object)line, (Object)format.toString(), (String)(testFile.getName() + " Expected format "));
            URL resource = ClassLoader.getSystemResource("CSVFileParser/" + split[0]);
            try (CSVParser parser = CSVParser.parse((URL)resource, (Charset)Charset.forName("UTF-8"), (CSVFormat)format);){
                for (CSVRecord record : parser) {
                    String comment;
                    String parsed = Arrays.toString(record.values());
                    if (checkComments && (comment = record.getComment().replace("\n", "\\n")) != null) {
                        parsed = parsed + "#" + comment;
                    }
                    int count = record.size();
                    Assertions.assertEquals((Object)this.readTestData(testData), (Object)(count + ":" + parsed), (String)testFile.getName());
                }
            }
        }
    }
}

