/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.junit.Assert;
import org.junit.Test;

public class CSVFormatTest {
    private static void assertNotEquals(Object right, Object left) {
        Assert.assertFalse((boolean)right.equals(left));
        Assert.assertFalse((boolean)left.equals(right));
    }

    private static CSVFormat copy(CSVFormat format) {
        return format.withDelimiter(format.getDelimiter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelimiterSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelimiterSameAsEscapeThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('!').withEscape('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateHeaderElements() {
        CSVFormat.DEFAULT.withHeader(new String[]{"A", "A"});
    }

    @Test
    public void testEquals() {
        CSVFormat right = CSVFormat.DEFAULT;
        CSVFormat left = CSVFormatTest.copy(right);
        Assert.assertFalse((boolean)right.equals(null));
        Assert.assertFalse((boolean)right.equals((Object)"A String Instance"));
        Assert.assertEquals((Object)right, (Object)right);
        Assert.assertEquals((Object)right, (Object)left);
        Assert.assertEquals((Object)left, (Object)right);
        Assert.assertEquals((long)right.hashCode(), (long)right.hashCode());
        Assert.assertEquals((long)right.hashCode(), (long)left.hashCode());
    }

    @Test
    public void testEqualsCommentStart() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withCommentMarker('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsDelimiter() {
        CSVFormat right = CSVFormat.newFormat((char)'!');
        CSVFormat left = CSVFormat.newFormat((char)'?');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsEscape() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withEscape('+').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withEscape('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsHeader() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withHeader(new String[]{"One", "Two", "Three"}).withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withHeader(new String[]{"Three", "Two", "One"});
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreEmptyLines() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreEmptyLines(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreSurroundingSpaces() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreSurroundingSpaces(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsLeftNoQuoteRightQuote() {
        CSVFormat left = CSVFormat.newFormat((char)',').withQuote(null);
        CSVFormat right = left.withQuote('#');
        CSVFormatTest.assertNotEquals(left, right);
    }

    @Test
    public void testEqualsNoQuotes() {
        CSVFormat left = CSVFormat.newFormat((char)',').withQuote(null);
        CSVFormat right = left.withQuote(null);
        Assert.assertEquals((Object)left, (Object)right);
    }

    @Test
    public void testEqualsNullString() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null");
        CSVFormat left = right.withNullString("---");
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsOne() {
        CSVFormat cSVFormatOne = CSVFormat.INFORMIX_UNLOAD;
        CSVFormat cSVFormatTwo = CSVFormat.MYSQL;
        Assert.assertEquals((long)92L, (long)cSVFormatOne.getEscapeCharacter().charValue());
        TestCase.assertNull((Object)cSVFormatOne.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormatOne.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormatOne.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormatOne.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormatOne.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatOne.isCommentMarkerSet());
        Assert.assertTrue((boolean)cSVFormatOne.isQuoteCharacterSet());
        Assert.assertEquals((long)124L, (long)cSVFormatOne.getDelimiter());
        Assert.assertFalse((boolean)cSVFormatOne.getAllowMissingColumnNames());
        Assert.assertTrue((boolean)cSVFormatOne.isEscapeCharacterSet());
        Assert.assertEquals((Object)"\n", (Object)cSVFormatOne.getRecordSeparator());
        Assert.assertEquals((long)34L, (long)cSVFormatOne.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatOne.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormatOne.getTrim());
        Assert.assertFalse((boolean)cSVFormatOne.isNullStringSet());
        TestCase.assertNull((Object)cSVFormatOne.getNullString());
        Assert.assertFalse((boolean)cSVFormatOne.getIgnoreSurroundingSpaces());
        Assert.assertTrue((boolean)cSVFormatTwo.isEscapeCharacterSet());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        Assert.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)cSVFormatTwo.getQuoteMode());
        Assert.assertEquals((long)9L, (long)cSVFormatTwo.getDelimiter());
        Assert.assertEquals((Object)"\n", (Object)cSVFormatTwo.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertEquals((long)92L, (long)cSVFormatTwo.getEscapeCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertEquals((Object)"\\N", (Object)cSVFormatTwo.getNullString());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormatTwo.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormatOne);
        Assert.assertFalse((boolean)cSVFormatTwo.equals((Object)cSVFormatOne));
        Assert.assertEquals((long)92L, (long)cSVFormatOne.getEscapeCharacter().charValue());
        TestCase.assertNull((Object)cSVFormatOne.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormatOne.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormatOne.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormatOne.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormatOne.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatOne.isCommentMarkerSet());
        Assert.assertTrue((boolean)cSVFormatOne.isQuoteCharacterSet());
        Assert.assertEquals((long)124L, (long)cSVFormatOne.getDelimiter());
        Assert.assertFalse((boolean)cSVFormatOne.getAllowMissingColumnNames());
        Assert.assertTrue((boolean)cSVFormatOne.isEscapeCharacterSet());
        Assert.assertEquals((Object)"\n", (Object)cSVFormatOne.getRecordSeparator());
        Assert.assertEquals((long)34L, (long)cSVFormatOne.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatOne.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormatOne.getTrim());
        Assert.assertFalse((boolean)cSVFormatOne.isNullStringSet());
        TestCase.assertNull((Object)cSVFormatOne.getNullString());
        Assert.assertFalse((boolean)cSVFormatOne.getIgnoreSurroundingSpaces());
        Assert.assertTrue((boolean)cSVFormatTwo.isEscapeCharacterSet());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        Assert.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)cSVFormatTwo.getQuoteMode());
        Assert.assertEquals((long)9L, (long)cSVFormatTwo.getDelimiter());
        Assert.assertEquals((Object)"\n", (Object)cSVFormatTwo.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertEquals((long)92L, (long)cSVFormatTwo.getEscapeCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertEquals((Object)"\\N", (Object)cSVFormatTwo.getNullString());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormatTwo.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertNotSame((Object)cSVFormatOne, (Object)cSVFormatTwo);
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormatOne);
        Assert.assertFalse((boolean)cSVFormatOne.equals((Object)cSVFormatTwo));
        Assert.assertFalse((boolean)cSVFormatTwo.equals((Object)cSVFormatOne));
        Assert.assertFalse((boolean)cSVFormatTwo.equals((Object)cSVFormatOne));
    }

    @Test
    public void testEqualsQuoteChar() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"');
        CSVFormat left = right.withQuote('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsQuotePolicy() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withQuoteMode(QuoteMode.MINIMAL);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsRecordSeparator() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withRecordSeparator('\n');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsSkipHeaderRecord() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null").withSkipHeaderRecord();
        CSVFormat left = right.withSkipHeaderRecord(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsWithNull() {
        CSVFormat cSVFormat = CSVFormat.POSTGRESQL_TEXT;
        Assert.assertEquals((long)92L, (long)cSVFormat.getEscapeCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertEquals((Object)"\\N", (Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertTrue((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)cSVFormat.getQuoteMode());
        Assert.assertEquals((long)9L, (long)cSVFormat.getDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        Assert.assertEquals((Object)"\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertTrue((boolean)cSVFormat.isNullStringSet());
        Assert.assertEquals((long)92L, (long)cSVFormat.getEscapeCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertEquals((Object)"\\N", (Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertTrue((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)cSVFormat.getQuoteMode());
        Assert.assertEquals((long)9L, (long)cSVFormat.getDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        Assert.assertEquals((Object)"\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertTrue((boolean)cSVFormat.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormat.equals(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEscapeSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withEscape('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEscapeSameAsCommentStartThrowsExceptionForWrapperType() {
        CSVFormat.DEFAULT.withEscape(new Character('!')).withCommentMarker(new Character('!'));
    }

    @Test
    public void testFormat() {
        CSVFormat format = CSVFormat.DEFAULT;
        Assert.assertEquals((Object)"", (Object)format.format(new Object[0]));
        Assert.assertEquals((Object)"a,b,c", (Object)format.format(new Object[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"\"x,y\",z", (Object)format.format(new Object[]{"x,y", "z"}));
    }

    @Test
    public void testFormatThrowsNullPointerException() {
        CSVFormat cSVFormat = CSVFormat.MYSQL;
        try {
            cSVFormat.format((Object[])null);
            Assert.fail((String)"Expecting exception: NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)CSVFormat.class.getName(), (Object)e.getStackTrace()[0].getClassName());
        }
    }

    @Test
    public void testGetHeader() throws Exception {
        String[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(header);
        Object[] headerCopy = formatWithHeader.getHeader();
        headerCopy[0] = "A";
        headerCopy[1] = "B";
        headerCopy[2] = "C";
        Assert.assertFalse((boolean)Arrays.equals(formatWithHeader.getHeader(), headerCopy));
        Assert.assertNotSame((Object)formatWithHeader.getHeader(), (Object)headerCopy);
    }

    @Test
    public void testHashCodeAndWithIgnoreHeaderCase() {
        CSVFormat cSVFormat = CSVFormat.INFORMIX_UNLOAD_CSV;
        CSVFormat cSVFormatTwo = cSVFormat.withIgnoreHeaderCase();
        cSVFormatTwo.hashCode();
        Assert.assertTrue((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertTrue((boolean)cSVFormatTwo.equals((Object)cSVFormat));
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
    }

    @Test
    public void testNewFormat() {
        CSVFormat cSVFormat = CSVFormat.newFormat((char)'X');
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        TestCase.assertNull((Object)cSVFormat.getRecordSeparator());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertEquals((long)88L, (long)cSVFormat.getDelimiter());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getQuoteCharacter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        TestCase.assertNull((Object)cSVFormat.getRecordSeparator());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertEquals((long)88L, (long)cSVFormat.getDelimiter());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getQuoteCharacter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreEmptyLines());
    }

    @Test
    public void testNullRecordSeparatorCsv106() {
        CSVFormat format = CSVFormat.newFormat((char)';').withSkipHeaderRecord().withHeader(new String[]{"H1", "H2"});
        String formatStr = format.format(new Object[]{"A", "B"});
        Assert.assertNotNull((Object)formatStr);
        Assert.assertFalse((boolean)formatStr.endsWith("null"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withQuote('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsCommentStartThrowsExceptionForWrapperType() {
        CSVFormat.DEFAULT.withQuote(new Character('!')).withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsDelimiterThrowsException() {
        CSVFormat.DEFAULT.withQuote('!').withDelimiter('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuotePolicyNoneWithoutEscapeThrowsException() {
        CSVFormat.newFormat((char)'!').withQuoteMode(QuoteMode.NONE);
    }

    @Test
    public void testRFC4180() {
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getCommentMarker());
        Assert.assertEquals((long)44L, (long)CSVFormat.RFC4180.getDelimiter());
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getEscapeCharacter());
        Assert.assertFalse((boolean)CSVFormat.RFC4180.getIgnoreEmptyLines());
        Assert.assertEquals((Object)Character.valueOf('\"'), (Object)CSVFormat.RFC4180.getQuoteCharacter());
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getQuoteMode());
        Assert.assertEquals((Object)"\r\n", (Object)CSVFormat.RFC4180.getRecordSeparator());
    }

    @Test
    public void testSerialization() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(CSVFormat.DEFAULT);
            oos.flush();
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        CSVFormat format = (CSVFormat)in.readObject();
        Assert.assertNotNull((Object)format);
        Assert.assertEquals((String)"delimiter", (long)CSVFormat.DEFAULT.getDelimiter(), (long)format.getDelimiter());
        Assert.assertEquals((String)"encapsulator", (Object)CSVFormat.DEFAULT.getQuoteCharacter(), (Object)format.getQuoteCharacter());
        Assert.assertEquals((String)"comment start", (Object)CSVFormat.DEFAULT.getCommentMarker(), (Object)format.getCommentMarker());
        Assert.assertEquals((String)"record separator", (Object)CSVFormat.DEFAULT.getRecordSeparator(), (Object)format.getRecordSeparator());
        Assert.assertEquals((String)"escape", (Object)CSVFormat.DEFAULT.getEscapeCharacter(), (Object)format.getEscapeCharacter());
        Assert.assertEquals((String)"trim", (Object)CSVFormat.DEFAULT.getIgnoreSurroundingSpaces(), (Object)format.getIgnoreSurroundingSpaces());
        Assert.assertEquals((String)"empty lines", (Object)CSVFormat.DEFAULT.getIgnoreEmptyLines(), (Object)format.getIgnoreEmptyLines());
    }

    @Test
    public void testToString() {
        String string = CSVFormat.INFORMIX_UNLOAD.toString();
        Assert.assertEquals((Object)"Delimiter=<|> Escape=<\\> QuoteChar=<\"> RecordSeparator=<\n> EmptyLines:ignored SkipHeaderRecord:false", (Object)string);
    }

    @Test
    public void testToStringAndWithCommentMarkerTakingCharacter() {
        CSVFormat.Predefined cSVFormat_Predefined = CSVFormat.Predefined.Default;
        CSVFormat cSVFormat = cSVFormat_Predefined.getFormat();
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Character character = Character.valueOf('n');
        CSVFormat cSVFormatTwo = cSVFormat.withCommentMarker(character);
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        Assert.assertEquals((long)34L, (long)cSVFormatTwo.getQuoteCharacter().charValue());
        TestCase.assertNull((Object)cSVFormatTwo.getNullString());
        Assert.assertEquals((long)44L, (long)cSVFormatTwo.getDelimiter());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertTrue((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        TestCase.assertNull((Object)cSVFormatTwo.getEscapeCharacter());
        Assert.assertTrue((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormatTwo.getRecordSeparator());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteMode());
        Assert.assertEquals((long)110L, (long)cSVFormatTwo.getCommentMarker().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormatTwo.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertNotSame((Object)cSVFormat, (Object)cSVFormatTwo);
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormat);
        Assert.assertFalse((boolean)cSVFormatTwo.equals((Object)cSVFormat));
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        Assert.assertEquals((long)34L, (long)cSVFormatTwo.getQuoteCharacter().charValue());
        TestCase.assertNull((Object)cSVFormatTwo.getNullString());
        Assert.assertEquals((long)44L, (long)cSVFormatTwo.getDelimiter());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertTrue((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        TestCase.assertNull((Object)cSVFormatTwo.getEscapeCharacter());
        Assert.assertTrue((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormatTwo.getRecordSeparator());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteMode());
        Assert.assertEquals((long)110L, (long)cSVFormatTwo.getCommentMarker().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        Assert.assertFalse((boolean)cSVFormatTwo.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertNotSame((Object)cSVFormat, (Object)cSVFormatTwo);
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormat);
        Assert.assertFalse((boolean)cSVFormat.equals((Object)cSVFormatTwo));
        Assert.assertFalse((boolean)cSVFormatTwo.equals((Object)cSVFormat));
        Assert.assertEquals((Object)"Delimiter=<,> QuoteChar=<\"> CommentStart=<n> RecordSeparator=<\r\n> EmptyLines:ignored SkipHeaderRecord:false", (Object)cSVFormatTwo.toString());
    }

    @Test
    public void testWithCommentStart() throws Exception {
        CSVFormat formatWithCommentStart = CSVFormat.DEFAULT.withCommentMarker('#');
        Assert.assertEquals((Object)Character.valueOf('#'), (Object)formatWithCommentStart.getCommentMarker());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithCommentStartCRThrowsException() {
        CSVFormat.DEFAULT.withCommentMarker('\r');
    }

    @Test
    public void testWithDelimiter() throws Exception {
        CSVFormat formatWithDelimiter = CSVFormat.DEFAULT.withDelimiter('!');
        Assert.assertEquals((long)33L, (long)formatWithDelimiter.getDelimiter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithDelimiterLFThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('\n');
    }

    @Test
    public void testWithEmptyEnum() throws Exception {
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(EmptyEnum.class);
        Assert.assertTrue((formatWithHeader.getHeader().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithEscape() throws Exception {
        CSVFormat formatWithEscape = CSVFormat.DEFAULT.withEscape('&');
        Assert.assertEquals((Object)Character.valueOf('&'), (Object)formatWithEscape.getEscapeCharacter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithEscapeCRThrowsExceptions() {
        CSVFormat.DEFAULT.withEscape('\r');
    }

    @Test
    public void testWithFirstRecordAsHeader() throws Exception {
        CSVFormat formatWithFirstRecordAsHeader = CSVFormat.DEFAULT.withFirstRecordAsHeader();
        Assert.assertTrue((boolean)formatWithFirstRecordAsHeader.getSkipHeaderRecord());
        Assert.assertTrue((formatWithFirstRecordAsHeader.getHeader().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithHeader() throws Exception {
        Object[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader((String[])header);
        Assert.assertArrayEquals((Object[])header, (Object[])formatWithHeader.getHeader());
        Assert.assertNotSame((Object)header, (Object)formatWithHeader.getHeader());
    }

    @Test
    public void testWithHeaderComments() {
        CSVFormat cSVFormat = CSVFormat.DEFAULT;
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Object[] objectArray = new Object[8];
        CSVFormat cSVFormatTwo = cSVFormat.withHeaderComments(objectArray);
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        TestCase.assertNull((Object)cSVFormatTwo.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        Assert.assertFalse((boolean)cSVFormatTwo.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        Assert.assertEquals((long)34L, (long)cSVFormatTwo.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        TestCase.assertNull((Object)cSVFormatTwo.getNullString());
        Assert.assertFalse((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormatTwo.getRecordSeparator());
        Assert.assertEquals((long)44L, (long)cSVFormatTwo.getDelimiter());
        TestCase.assertNull((Object)cSVFormatTwo.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertNotSame((Object)cSVFormat, (Object)cSVFormatTwo);
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormat);
        Assert.assertTrue((boolean)cSVFormatTwo.equals((Object)cSVFormat));
        String string = cSVFormatTwo.format(objectArray);
        Assert.assertEquals((long)34L, (long)cSVFormat.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormat.isCommentMarkerSet());
        Assert.assertFalse((boolean)cSVFormat.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormat.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormat.getSkipHeaderRecord());
        TestCase.assertNull((Object)cSVFormat.getQuoteMode());
        Assert.assertEquals((long)44L, (long)cSVFormat.getDelimiter());
        Assert.assertTrue((boolean)cSVFormat.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormat.getCommentMarker());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormat.getRecordSeparator());
        Assert.assertFalse((boolean)cSVFormat.getTrailingDelimiter());
        Assert.assertFalse((boolean)cSVFormat.getAllowMissingColumnNames());
        Assert.assertFalse((boolean)cSVFormat.getTrim());
        Assert.assertFalse((boolean)cSVFormat.isNullStringSet());
        TestCase.assertNull((Object)cSVFormat.getNullString());
        Assert.assertFalse((boolean)cSVFormat.getIgnoreSurroundingSpaces());
        TestCase.assertNull((Object)cSVFormat.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreHeaderCase());
        TestCase.assertNull((Object)cSVFormatTwo.getQuoteMode());
        Assert.assertTrue((boolean)cSVFormatTwo.getIgnoreEmptyLines());
        Assert.assertFalse((boolean)cSVFormatTwo.getIgnoreSurroundingSpaces());
        TestCase.assertNull((Object)cSVFormatTwo.getEscapeCharacter());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrim());
        Assert.assertFalse((boolean)cSVFormatTwo.isEscapeCharacterSet());
        Assert.assertTrue((boolean)cSVFormatTwo.isQuoteCharacterSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getSkipHeaderRecord());
        Assert.assertEquals((long)34L, (long)cSVFormatTwo.getQuoteCharacter().charValue());
        Assert.assertFalse((boolean)cSVFormatTwo.getAllowMissingColumnNames());
        TestCase.assertNull((Object)cSVFormatTwo.getNullString());
        Assert.assertFalse((boolean)cSVFormatTwo.isNullStringSet());
        Assert.assertFalse((boolean)cSVFormatTwo.getTrailingDelimiter());
        Assert.assertEquals((Object)"\r\n", (Object)cSVFormatTwo.getRecordSeparator());
        Assert.assertEquals((long)44L, (long)cSVFormatTwo.getDelimiter());
        TestCase.assertNull((Object)cSVFormatTwo.getCommentMarker());
        Assert.assertFalse((boolean)cSVFormatTwo.isCommentMarkerSet());
        Assert.assertNotSame((Object)cSVFormat, (Object)cSVFormatTwo);
        Assert.assertNotSame((Object)cSVFormatTwo, (Object)cSVFormat);
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((boolean)cSVFormat.equals((Object)cSVFormatTwo));
        Assert.assertTrue((boolean)cSVFormatTwo.equals((Object)cSVFormat));
        Assert.assertEquals((Object)",,,,,,,", (Object)string);
    }

    @Test
    public void testWithHeaderEnum() throws Exception {
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(Header.class);
        Assert.assertArrayEquals((Object[])new String[]{"Name", "Email", "Phone"}, (Object[])formatWithHeader.getHeader());
    }

    @Test
    public void testWithIgnoreEmptyLines() throws Exception {
        Assert.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines(false).getIgnoreEmptyLines());
        Assert.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines().getIgnoreEmptyLines());
    }

    @Test
    public void testWithIgnoreSurround() throws Exception {
        Assert.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(false).getIgnoreSurroundingSpaces());
        Assert.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces().getIgnoreSurroundingSpaces());
    }

    @Test
    public void testWithNullString() throws Exception {
        CSVFormat formatWithNullString = CSVFormat.DEFAULT.withNullString("null");
        Assert.assertEquals((Object)"null", (Object)formatWithNullString.getNullString());
    }

    @Test
    public void testWithQuoteChar() throws Exception {
        CSVFormat formatWithQuoteChar = CSVFormat.DEFAULT.withQuote('\"');
        Assert.assertEquals((Object)Character.valueOf('\"'), (Object)formatWithQuoteChar.getQuoteCharacter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithQuoteLFThrowsException() {
        CSVFormat.DEFAULT.withQuote('\n');
    }

    @Test
    public void testWithQuotePolicy() throws Exception {
        CSVFormat formatWithQuotePolicy = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.ALL);
        Assert.assertEquals((Object)QuoteMode.ALL, (Object)formatWithQuotePolicy.getQuoteMode());
    }

    @Test
    public void testWithRecordSeparatorCR() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\r');
        Assert.assertEquals((Object)String.valueOf('\r'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorCRLF() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator("\r\n");
        Assert.assertEquals((Object)"\r\n", (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorLF() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\n');
        Assert.assertEquals((Object)String.valueOf('\n'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithSystemRecordSeparator() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withSystemRecordSeparator();
        Assert.assertEquals((Object)System.getProperty("line.separator"), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    public static enum Header {
        Name,
        Email,
        Phone;

    }

    public static enum EmptyEnum {

    }
}

