/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.Utils;
import org.apache.commons.io.input.BOMInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CSVParserTest {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String UTF_8_NAME = UTF_8.name();
    private static final String CSV_INPUT = "a,b,c,d\n a , b , 1 2 \n\"foo baar\", b,\n   \"foo\n,,\n\"\",,\n\"\"\",d,e\n";
    private static final String CSV_INPUT_1 = "a,b,c,d";
    private static final String CSV_INPUT_2 = "a,b,1 2";
    private static final String[][] RESULT = new String[][]{{"a", "b", "c", "d"}, {"a", "b", "1 2"}, {"foo baar", "b", ""}, {"foo\n,,\n\",,\n\"", "d", "e"}};

    private BOMInputStream createBOMInputStream(String resource) throws IOException {
        URL url = ClassLoader.getSystemClassLoader().getResource(resource);
        return new BOMInputStream(url.openStream());
    }

    private void parseFully(CSVParser parser) {
        for (CSVRecord csvRecord : parser) {
            Assert.assertNotNull((Object)csvRecord);
        }
    }

    @Test
    public void testBackslashEscaping() throws IOException {
        String code = "one,two,three\n'',''\n/',/'\n'/'','/''\n'''',''''\n/,,/,\n//,//\n'//','//'\n   8   ,   \"quoted \"\" /\" // string\"   \n9,   /\n   \n";
        String[][] res = new String[][]{{"one", "two", "three"}, {"", ""}, {"'", "'"}, {"'", "'"}, {"'", "'"}, {",", ","}, {"/", "/"}, {"/", "/"}, {"   8   ", "   \"quoted \"\" /\" / string\"   "}, {"9", "   \n   "}};
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\'').withRecordSeparator("\r\n").withEscape('/').withIgnoreEmptyLines();
        try (CSVParser parser = CSVParser.parse((String)"one,two,three\n'',''\n/',/'\n'/'','/''\n'''',''''\n/,,/,\n//,//\n'//','//'\n   8   ,   \"quoted \"\" /\" // string\"   \n9,   /\n   \n", (CSVFormat)format);){
            List records = parser.getRecords();
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            Utils.compare("Records do not match expected result", res, records);
        }
    }

    @Test
    public void testBackslashEscaping2() throws IOException {
        String code = " , , \n \t ,  , \n // , /, , /,\n";
        String[][] res = new String[][]{{" ", " ", " "}, {" \t ", "  ", " "}, {" / ", " , ", " ,"}};
        CSVFormat format = CSVFormat.newFormat((char)',').withRecordSeparator("\r\n").withEscape('/').withIgnoreEmptyLines();
        try (CSVParser parser = CSVParser.parse((String)" , , \n \t ,  , \n // , /, , /,\n", (CSVFormat)format);){
            List records = parser.getRecords();
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            Utils.compare("", res, records);
        }
    }

    @Test
    @Ignore
    public void testBackslashEscapingOld() throws IOException {
        String code = "one,two,three\non\\\"e,two\non\"e,two\none,\"tw\\\"o\"\none,\"t\\,wo\"\none,two,\"th,ree\"\n\"a\\\\\"\na\\,b\n\"a\\\\,b\"";
        String[][] res = new String[][]{{"one", "two", "three"}, {"on\\\"e", "two"}, {"on\"e", "two"}, {"one", "tw\"o"}, {"one", "t\\,wo"}, {"one", "two", "th,ree"}, {"a\\\\"}, {"a\\", "b"}, {"a\\\\,b"}};
        try (CSVParser parser = CSVParser.parse((String)"one,two,three\non\\\"e,two\non\"e,two\none,\"tw\\\"o\"\none,\"t\\,wo\"\none,two,\"th,ree\"\n\"a\\\\\"\na\\,b\n\"a\\\\,b\"", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
        }
    }

    @Test
    @Ignore(value="CSV-107")
    public void testBOM() throws IOException {
        URL url = ClassLoader.getSystemClassLoader().getResource("CSVFileParser/bom.csv");
        try (CSVParser parser = CSVParser.parse((URL)url, (Charset)Charset.forName(UTF_8_NAME), (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));){
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
    }

    @Test
    public void testBOMInputStream_ParserWithInputStream() throws IOException {
        try (BOMInputStream inputStream = this.createBOMInputStream("CSVFileParser/bom.csv");
             CSVParser parser = CSVParser.parse((InputStream)inputStream, (Charset)UTF_8, (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));){
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
    }

    @Test
    public void testBOMInputStream_ParserWithReader() throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)this.createBOMInputStream("CSVFileParser/bom.csv"), UTF_8_NAME);
             CSVParser parser = new CSVParser((Reader)reader, CSVFormat.EXCEL.withHeader(new String[0]));){
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
    }

    @Test
    public void testBOMInputStream_parseWithReader() throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)this.createBOMInputStream("CSVFileParser/bom.csv"), UTF_8_NAME);
             CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));){
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
    }

    @Test
    public void testCarriageReturnEndings() throws IOException {
        String code = "foo\rbaar,\rhello,world\r,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\rbaar,\rhello,world\r,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
        }
    }

    @Test
    public void testCarriageReturnLineFeedEndings() throws IOException {
        String code = "foo\r\nbaar,\r\nhello,world\r\n,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\r\nbaar,\r\nhello,world\r\n,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testClose() throws Exception {
        Iterator records;
        StringReader in = new StringReader("# comment\na,b,c\n1,2,3\nx,y,z");
        try (CSVParser parser = CSVFormat.DEFAULT.withCommentMarker('#').withHeader(new String[0]).parse((Reader)in);){
            records = parser.iterator();
            Assert.assertTrue((boolean)records.hasNext());
        }
        Assert.assertFalse((boolean)records.hasNext());
        records.next();
    }

    @Test
    public void testCSV57() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"", (CSVFormat)CSVFormat.DEFAULT);){
            List list = parser.getRecords();
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)0L, (long)list.size());
        }
    }

    @Test
    public void testDefaultFormat() throws IOException {
        List records;
        String code = "a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n";
        String[][] res = new String[][]{{"a", "b#"}, {"\n", " ", "#"}, {"#", ""}, {"# Final comment"}};
        CSVFormat format = CSVFormat.DEFAULT;
        Assert.assertFalse((boolean)format.isCommentMarkerSet());
        String[][] res_comments = new String[][]{{"a", "b#"}, {"\n", " ", "#"}};
        try (CSVParser parser = CSVParser.parse((String)"a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n", (CSVFormat)format);){
            records = parser.getRecords();
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            Utils.compare("Failed to parse without comments", res, records);
            format = CSVFormat.DEFAULT.withCommentMarker('#');
        }
        parser = CSVParser.parse((String)"a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n", (CSVFormat)format);
        var6_6 = null;
        try {
            records = parser.getRecords();
            Utils.compare("Failed to parse with comments", res_comments, records);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateHeadersNotAllowed() throws Exception {
        CSVParser.parse((String)"a,b,a\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]).withAllowDuplicateHeaderNames(false));
    }

    @Test
    public void testDuplicateHeadersAllowedByDefault() throws Exception {
        CSVParser.parse((String)"a,b,a\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));
    }

    @Test
    public void testEmptyFileHeaderParsing() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"", (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader());){
            Assert.assertNull((Object)parser.nextRecord());
            Assert.assertTrue((boolean)parser.getHeaderNames().isEmpty());
        }
    }

    @Test
    public void testEmptyFile() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"", (CSVFormat)CSVFormat.DEFAULT);){
            Assert.assertNull((Object)parser.nextRecord());
        }
    }

    @Test
    public void testEmptyLineBehaviorCSV() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}};
        for (String code : codes) {
            try (CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.DEFAULT);){
                List records = parser.getRecords();
                Assert.assertEquals((long)res.length, (long)records.size());
                Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < res.length; ++i) {
                    Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
                }
            }
        }
    }

    @Test
    public void testEmptyLineBehaviorExcel() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}, {""}, {""}};
        for (String code : codes) {
            try (CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);){
                List records = parser.getRecords();
                Assert.assertEquals((long)res.length, (long)records.size());
                Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < res.length; ++i) {
                    Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
                }
            }
        }
    }

    @Test
    public void testEndOfFileBehaviorCSV() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\nworld,\r\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\r\n", "hello,\r\n\r\nworld,\"\"", "hello,\r\n\r\nworld,\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\n", "hello,\r\n\r\nworld,\"\""};
        String[][] res = new String[][]{{"hello", ""}, {"world", ""}};
        for (String code : codes) {
            try (CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.DEFAULT);){
                List records = parser.getRecords();
                Assert.assertEquals((long)res.length, (long)records.size());
                Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < res.length; ++i) {
                    Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
                }
            }
        }
    }

    @Test
    public void testEndOfFileBehaviorExcel() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\nworld,\r\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\r\n", "hello,\r\n\r\nworld,\"\"", "hello,\r\n\r\nworld,\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\n", "hello,\r\n\r\nworld,\"\""};
        String[][] res = new String[][]{{"hello", ""}, {""}, {"world", ""}};
        for (String code : codes) {
            try (CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);){
                List records = parser.getRecords();
                Assert.assertEquals((long)res.length, (long)records.size());
                Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < res.length; ++i) {
                    Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
                }
            }
        }
    }

    @Test
    public void testExcelFormat1() throws IOException {
        String code = "value1,value2,value3,value4\r\na,b,c,d\r\n  x,,,\r\n\r\n\"\"\"hello\"\"\",\"  \"\"world\"\"\",\"abc\ndef\",\r\n";
        String[][] res = new String[][]{{"value1", "value2", "value3", "value4"}, {"a", "b", "c", "d"}, {"  x", "", "", ""}, {""}, {"\"hello\"", "  \"world\"", "abc\ndef", ""}};
        try (CSVParser parser = CSVParser.parse((String)"value1,value2,value3,value4\r\na,b,c,d\r\n  x,,,\r\n\r\n\"\"\"hello\"\"\",\"  \"\"world\"\"\",\"abc\ndef\",\r\n", (CSVFormat)CSVFormat.EXCEL);){
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
        }
    }

    @Test
    public void testExcelFormat2() throws Exception {
        String code = "foo,baar\r\n\r\nhello,\r\n\r\nworld,\r\n";
        String[][] res = new String[][]{{"foo", "baar"}, {""}, {"hello", ""}, {""}, {"world", ""}};
        try (CSVParser parser = CSVParser.parse((String)"foo,baar\r\n\r\nhello,\r\n\r\nworld,\r\n", (CSVFormat)CSVFormat.EXCEL);){
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
        }
    }

    @Test
    public void testExcelHeaderCountLessThanData() throws Exception {
        String code = "A,B,C,,\r\na,b,c,d,e\r\n";
        try (CSVParser parser = CSVParser.parse((String)"A,B,C,,\r\na,b,c,d,e\r\n", (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));){
            for (CSVRecord record : parser.getRecords()) {
                Assert.assertEquals((Object)"a", (Object)record.get("A"));
                Assert.assertEquals((Object)"b", (Object)record.get("B"));
                Assert.assertEquals((Object)"c", (Object)record.get("C"));
            }
        }
    }

    @Test
    public void testFirstEndOfLineCr() throws IOException {
        String data = "foo\rbaar,\rhello,world\r,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\rbaar,\rhello,world\r,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
            Assert.assertEquals((Object)"\r", (Object)parser.getFirstEndOfLine());
        }
    }

    @Test
    public void testFirstEndOfLineCrLf() throws IOException {
        String data = "foo\r\nbaar,\r\nhello,world\r\n,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\r\nbaar,\r\nhello,world\r\n,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
            Assert.assertEquals((Object)"\r\n", (Object)parser.getFirstEndOfLine());
        }
    }

    @Test
    public void testFirstEndOfLineLf() throws IOException {
        String data = "foo\nbaar,\nhello,world\n,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\nbaar,\nhello,world\n,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
            Assert.assertEquals((Object)"\n", (Object)parser.getFirstEndOfLine());
        }
    }

    @Test
    public void testForEach() throws Exception {
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        try (StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");){
            for (CSVRecord record : CSVFormat.DEFAULT.parse((Reader)in)) {
                records.add(record);
            }
            Assert.assertEquals((long)3L, (long)records.size());
            Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((CSVRecord)records.get(0)).values());
            Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((CSVRecord)records.get(1)).values());
            Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])((CSVRecord)records.get(2)).values());
        }
    }

    @Test
    public void testGetHeaderMap() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));){
            Map headerMap = parser.getHeaderMap();
            Iterator columnNames = headerMap.keySet().iterator();
            Assert.assertEquals((Object)"A", columnNames.next());
            Assert.assertEquals((Object)"B", columnNames.next());
            Assert.assertEquals((Object)"C", columnNames.next());
            Iterator records = parser.iterator();
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)records.hasNext());
                CSVRecord record = (CSVRecord)records.next();
                Assert.assertEquals((Object)record.get(0), (Object)record.get("A"));
                Assert.assertEquals((Object)record.get(1), (Object)record.get("B"));
                Assert.assertEquals((Object)record.get(2), (Object)record.get("C"));
            }
            Assert.assertFalse((boolean)records.hasNext());
        }
    }

    @Test
    public void testGetHeaderNames() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));){
            Map nameIndexMap = parser.getHeaderMap();
            List headerNames = parser.getHeaderNames();
            Assert.assertNotNull((Object)headerNames);
            Assert.assertEquals((long)nameIndexMap.size(), (long)headerNames.size());
            for (int i = 0; i < headerNames.size(); ++i) {
                String name = (String)headerNames.get(i);
                Assert.assertEquals((long)i, (long)((Integer)nameIndexMap.get(name)).intValue());
            }
        }
    }

    @Test
    public void testGetHeaderNamesReadOnly() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));){
            List headerNames = parser.getHeaderNames();
            Assert.assertNotNull((Object)headerNames);
            try {
                headerNames.add("This is a read-only list.");
                Assert.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetLine() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)CSV_INPUT, (CSVFormat)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());){
            for (Object[] objectArray : RESULT) {
                Assert.assertArrayEquals((Object[])objectArray, (Object[])parser.nextRecord().values());
            }
            Assert.assertNull((Object)parser.nextRecord());
        }
    }

    @Test
    public void testGetLineNumberWithCR() throws Exception {
        this.validateLineNumbers(String.valueOf('\r'));
    }

    @Test
    public void testGetLineNumberWithCRLF() throws Exception {
        this.validateLineNumbers("\r\n");
    }

    @Test
    public void testGetLineNumberWithLF() throws Exception {
        this.validateLineNumbers(String.valueOf('\n'));
    }

    @Test
    public void testGetOneLine() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)CSV_INPUT_1, (CSVFormat)CSVFormat.DEFAULT);){
            CSVRecord record = (CSVRecord)parser.getRecords().get(0);
            Assert.assertArrayEquals((Object[])RESULT[0], (Object[])record.values());
        }
    }

    @Test
    public void testGetOneLineOneParser() throws IOException {
        CSVFormat format = CSVFormat.DEFAULT;
        try (PipedWriter writer = new PipedWriter();
             CSVParser parser = new CSVParser((Reader)new PipedReader(writer), format);){
            writer.append(CSV_INPUT_1);
            writer.append(format.getRecordSeparator());
            CSVRecord record1 = parser.nextRecord();
            Assert.assertArrayEquals((Object[])RESULT[0], (Object[])record1.values());
            writer.append(CSV_INPUT_2);
            writer.append(format.getRecordSeparator());
            CSVRecord record2 = parser.nextRecord();
            Assert.assertArrayEquals((Object[])RESULT[1], (Object[])record2.values());
        }
    }

    @Test
    public void testGetRecordNumberWithCR() throws Exception {
        this.validateRecordNumbers(String.valueOf('\r'));
    }

    @Test
    public void testGetRecordNumberWithCRLF() throws Exception {
        this.validateRecordNumbers("\r\n");
    }

    @Test
    public void testGetRecordNumberWithLF() throws Exception {
        this.validateRecordNumbers(String.valueOf('\n'));
    }

    @Test
    public void testGetRecordPositionWithCRLF() throws Exception {
        this.validateRecordPosition("\r\n");
    }

    @Test
    public void testGetRecordPositionWithLF() throws Exception {
        this.validateRecordPosition(String.valueOf('\n'));
    }

    @Test
    public void testGetRecords() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)CSV_INPUT, (CSVFormat)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());){
            List records = parser.getRecords();
            Assert.assertEquals((long)RESULT.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < RESULT.length; ++i) {
                Assert.assertArrayEquals((Object[])RESULT[i], (Object[])((CSVRecord)records.get(i)).values());
            }
        }
    }

    @Test
    public void testGetRecordWithMultiLineValues() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"\"a\r\n1\",\"a\r\n2\"\r\n\"b\r\n1\",\"b\r\n2\"\r\n\"c\r\n1\",\"c\r\n2\"", (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator("\r\n"));){
            Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
            Assert.assertEquals((long)0L, (long)parser.getCurrentLineNumber());
            CSVRecord record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)3L, (long)parser.getCurrentLineNumber());
            Assert.assertEquals((long)1L, (long)record.getRecordNumber());
            Assert.assertEquals((long)1L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)6L, (long)parser.getCurrentLineNumber());
            Assert.assertEquals((long)2L, (long)record.getRecordNumber());
            Assert.assertEquals((long)2L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)8L, (long)parser.getCurrentLineNumber());
            Assert.assertEquals((long)3L, (long)record.getRecordNumber());
            Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNull((Object)record);
            Assert.assertEquals((long)8L, (long)parser.getCurrentLineNumber());
            Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        }
    }

    @Test
    public void testHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderComment() throws Exception {
        StringReader in = new StringReader("# comment\na,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withCommentMarker('#').withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderMissing() throws Exception {
        StringReader in = new StringReader("a,,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderMissingWithNull() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).withNullString("").withAllowMissingColumnNames().parse((Reader)in).iterator();
    }

    @Test
    public void testHeadersMissing() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).withAllowMissingColumnNames().parse((Reader)in).iterator();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHeadersMissingException() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
    }

    @Test
    public void testIgnoreCaseHeaderMapping() throws Exception {
        StringReader reader = new StringReader("1,2,3");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"One", "TWO", "three"}).withIgnoreHeaderCase().parse((Reader)reader).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("one"));
        Assert.assertEquals((Object)"2", (Object)record.get("two"));
        Assert.assertEquals((Object)"3", (Object)record.get("THREE"));
    }

    @Test
    public void testIgnoreEmptyLines() throws IOException {
        String code = "\nfoo,baar\n\r\n,\n\n,world\r\n\n";
        try (CSVParser parser = CSVParser.parse((String)"\nfoo,baar\n\r\n,\n\n,world\r\n\n", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)3L, (long)records.size());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFormat() throws Exception {
        CSVFormat invalidFormat = CSVFormat.DEFAULT.withDelimiter('\r');
        try (CSVParser parser = new CSVParser(null, invalidFormat);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test
    public void testIterator() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator iterator = CSVFormat.DEFAULT.parse((Reader)in).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail((String)"expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorSequenceBreaking() throws IOException {
        String fiveRows = "1\n2\n3\n4\n5\n";
        try (CSVParser parser = CSVFormat.DEFAULT.parse((Reader)new StringReader("1\n2\n3\n4\n5\n"));){
            CSVRecord record;
            int recordNumber = 0;
            Iterator iter = parser.iterator();
            recordNumber = 0;
            while (iter.hasNext()) {
                record = (CSVRecord)iter.next();
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
                if (recordNumber < 2) continue;
                break;
            }
            iter.hasNext();
            while (iter.hasNext()) {
                record = (CSVRecord)iter.next();
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
            }
        }
        parser = CSVFormat.DEFAULT.parse((Reader)new StringReader("1\n2\n3\n4\n5\n"));
        var3_3 = null;
        try {
            int recordNumber = 0;
            for (CSVRecord record : parser) {
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
                if (recordNumber < 2) continue;
                break;
            }
            for (CSVRecord record : parser) {
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
            }
        }
        catch (Throwable recordNumber) {
            var3_3 = recordNumber;
            throw recordNumber;
        }
        finally {
            if (parser != null) {
                if (var3_3 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable recordNumber) {
                        var3_3.addSuppressed(recordNumber);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = CSVFormat.DEFAULT.parse((Reader)new StringReader("1\n2\n3\n4\n5\n"));
        var3_3 = null;
        try {
            int recordNumber = 0;
            for (CSVRecord record : parser) {
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
                if (recordNumber < 2) continue;
                break;
            }
            parser.iterator().hasNext();
            for (CSVRecord record : parser) {
                Assert.assertEquals((Object)String.valueOf(++recordNumber), (Object)record.get(0));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var3_3 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }

    @Test
    public void testLineFeedEndings() throws IOException {
        String code = "foo\nbaar,\nhello,world\n,kanu";
        try (CSVParser parser = CSVParser.parse((String)"foo\nbaar,\nhello,world\n,kanu", (CSVFormat)CSVFormat.DEFAULT);){
            List records = parser.getRecords();
            Assert.assertEquals((long)4L, (long)records.size());
        }
    }

    @Test
    public void testMappedButNotSetAsOutlook2007ContactExport() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertTrue((boolean)record.isMapped("A"));
        Assert.assertTrue((boolean)record.isMapped("B"));
        Assert.assertTrue((boolean)record.isMapped("C"));
        Assert.assertTrue((boolean)record.isSet("A"));
        Assert.assertTrue((boolean)record.isSet("B"));
        Assert.assertFalse((boolean)record.isSet("C"));
        Assert.assertEquals((Object)"1", (Object)record.get("A"));
        Assert.assertEquals((Object)"2", (Object)record.get("B"));
        Assert.assertFalse((boolean)record.isConsistent());
        record = (CSVRecord)records.next();
        Assert.assertTrue((boolean)record.isMapped("A"));
        Assert.assertTrue((boolean)record.isMapped("B"));
        Assert.assertTrue((boolean)record.isMapped("C"));
        Assert.assertTrue((boolean)record.isSet("A"));
        Assert.assertTrue((boolean)record.isSet("B"));
        Assert.assertTrue((boolean)record.isSet("C"));
        Assert.assertEquals((Object)"x", (Object)record.get("A"));
        Assert.assertEquals((Object)"y", (Object)record.get("B"));
        Assert.assertEquals((Object)"z", (Object)record.get("C"));
        Assert.assertTrue((boolean)record.isConsistent());
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    @Ignore
    public void testMongoDbCsv() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"\"a a\",b,c\nd,e,f", (CSVFormat)CSVFormat.MONGODB_CSV);){
            Iterator itr1 = parser.iterator();
            Iterator itr2 = parser.iterator();
            CSVRecord first = (CSVRecord)itr1.next();
            Assert.assertEquals((Object)"a a", (Object)first.get(0));
            Assert.assertEquals((Object)"b", (Object)first.get(1));
            Assert.assertEquals((Object)"c", (Object)first.get(2));
            CSVRecord second = (CSVRecord)itr2.next();
            Assert.assertEquals((Object)"d", (Object)second.get(0));
            Assert.assertEquals((Object)"e", (Object)second.get(1));
            Assert.assertEquals((Object)"f", (Object)second.get(2));
        }
    }

    @Test
    public void testMultipleIterators() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b,c\r\nd,e,f", (CSVFormat)CSVFormat.DEFAULT);){
            Iterator itr1 = parser.iterator();
            CSVRecord first = (CSVRecord)itr1.next();
            Assert.assertEquals((Object)"a", (Object)first.get(0));
            Assert.assertEquals((Object)"b", (Object)first.get(1));
            Assert.assertEquals((Object)"c", (Object)first.get(2));
            CSVRecord second = (CSVRecord)itr1.next();
            Assert.assertEquals((Object)"d", (Object)second.get(0));
            Assert.assertEquals((Object)"e", (Object)second.get(1));
            Assert.assertEquals((Object)"f", (Object)second.get(2));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVParserNullReaderFormat() throws Exception {
        try (CSVParser parser = new CSVParser(null, CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVParserReaderNullFormat() throws Exception {
        try (CSVParser parser = new CSVParser((Reader)new StringReader(""), null);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test
    public void testNoHeaderMap() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT);){
            Assert.assertNull((Object)parser.getHeaderMap());
        }
    }

    @Test
    public void testParse() throws Exception {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL url = loader.getResource("CSVFileParser/test.csv");
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C", "D"});
        Charset charset = StandardCharsets.UTF_8;
        try (CSVParser parser = CSVParser.parse((Reader)new InputStreamReader(url.openStream(), charset), (CSVFormat)format);){
            this.parseFully(parser);
        }
        parser = CSVParser.parse((String)new String(Files.readAllBytes(Paths.get(url.toURI())), charset), (CSVFormat)format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = CSVParser.parse((File)new File(url.toURI()), (Charset)charset, (CSVFormat)format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = CSVParser.parse((InputStream)url.openStream(), (Charset)charset, (CSVFormat)format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = CSVParser.parse((Path)Paths.get(url.toURI()), (Charset)charset, (CSVFormat)format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = CSVParser.parse((URL)url, (Charset)charset, (CSVFormat)format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = new CSVParser((Reader)new InputStreamReader(url.openStream(), charset), format);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
        parser = new CSVParser((Reader)new InputStreamReader(url.openStream(), charset), format, 0L, 1L);
        var6_6 = null;
        try {
            this.parseFully(parser);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var6_6 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseFileNullFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((File)new File("CSVFileParser/test.csv"), (Charset)Charset.defaultCharset(), null);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullFileFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((File)null, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullPathFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((Path)null, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullStringFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)null, (CSVFormat)CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullUrlCharsetFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((URL)null, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParserUrlNullCharsetFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((URL)new URL("http://commons.apache.org"), null, (CSVFormat)CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseStringNullFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"csv data", (CSVFormat)null);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseUrlCharsetNullFormat() throws Exception {
        try (CSVParser parser = CSVParser.parse((URL)new URL("http://commons.apache.org"), (Charset)Charset.defaultCharset(), null);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test
    public void testProvidedHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}).parse((Reader)in).iterator();
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertTrue((boolean)record.isMapped("A"));
            Assert.assertTrue((boolean)record.isMapped("B"));
            Assert.assertTrue((boolean)record.isMapped("C"));
            Assert.assertFalse((boolean)record.isMapped("NOT MAPPED"));
            Assert.assertEquals((Object)record.get(0), (Object)record.get("A"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("B"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("C"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testProvidedHeaderAuto() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertTrue((boolean)record.isMapped("a"));
            Assert.assertTrue((boolean)record.isMapped("b"));
            Assert.assertTrue((boolean)record.isMapped("c"));
            Assert.assertFalse((boolean)record.isMapped("NOT MAPPED"));
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testRoundtrip() throws Exception {
        StringWriter out = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT);){
            String input = "a,b,c\r\n1,2,3\r\nx,y,z\r\n";
            for (CSVRecord record : CSVParser.parse((String)"a,b,c\r\n1,2,3\r\nx,y,z\r\n", (CSVFormat)CSVFormat.DEFAULT)) {
                printer.printRecord((Iterable)record);
            }
            Assert.assertEquals((Object)"a,b,c\r\n1,2,3\r\nx,y,z\r\n", (Object)out.toString());
        }
    }

    @Test
    public void testSkipAutoHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("a"));
        Assert.assertEquals((Object)"2", (Object)record.get("b"));
        Assert.assertEquals((Object)"3", (Object)record.get("c"));
    }

    @Test
    public void testSkipHeaderOverrideDuplicateHeaders() throws Exception {
        StringReader in = new StringReader("a,a,a\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
    }

    @Test
    public void testSkipSetAltHeaders() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
    }

    @Test
    public void testSkipSetHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"a", "b", "c"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("a"));
        Assert.assertEquals((Object)"2", (Object)record.get("b"));
        Assert.assertEquals((Object)"3", (Object)record.get("c"));
    }

    @Test
    @Ignore
    public void testStartWithEmptyLinesThenHeaders() throws Exception {
        String[] codes = new String[]{"\r\n\r\n\r\nhello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}, {""}, {""}};
        for (String code : codes) {
            try (CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);){
                List records = parser.getRecords();
                Assert.assertEquals((long)res.length, (long)records.size());
                Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < res.length; ++i) {
                    Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
                }
            }
        }
    }

    @Test
    public void testTrailingDelimiter() throws Exception {
        StringReader in = new StringReader("a,a,a,\n\"1\",\"2\",\"3\",\nx,y,z,");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().withTrailingDelimiter().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
        Assert.assertEquals((long)3L, (long)record.size());
    }

    @Test
    public void testTrim() throws Exception {
        StringReader in = new StringReader("a,a,a\n\" 1 \",\" 2 \",\" 3 \"\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().withTrim().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
        Assert.assertEquals((long)3L, (long)record.size());
    }

    @Test
    public void testRepeatedHeadersAreReturnedInCSVRecordHeaderNames() throws IOException {
        StringReader in = new StringReader("header1,header2,header1\n1,2,3\n4,5,6");
        Iterator records = CSVFormat.DEFAULT.withFirstRecordAsHeader().withTrim().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals(Arrays.asList("header1", "header2", "header1"), (Object)record.getParser().getHeaderNames());
    }

    private void validateLineNumbers(String lineSeparator) throws IOException {
        try (CSVParser parser = CSVParser.parse((String)("a" + lineSeparator + "b" + lineSeparator + "c"), (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator(lineSeparator));){
            Assert.assertEquals((long)0L, (long)parser.getCurrentLineNumber());
            Assert.assertNotNull((Object)parser.nextRecord());
            Assert.assertEquals((long)1L, (long)parser.getCurrentLineNumber());
            Assert.assertNotNull((Object)parser.nextRecord());
            Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
            Assert.assertNotNull((Object)parser.nextRecord());
            Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
            Assert.assertNull((Object)parser.nextRecord());
            Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
        }
    }

    private void validateRecordNumbers(String lineSeparator) throws IOException {
        try (CSVParser parser = CSVParser.parse((String)("a" + lineSeparator + "b" + lineSeparator + "c"), (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator(lineSeparator));){
            Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
            CSVRecord record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)1L, (long)record.getRecordNumber());
            Assert.assertEquals((long)1L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)2L, (long)record.getRecordNumber());
            Assert.assertEquals((long)2L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)3L, (long)record.getRecordNumber());
            Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
            record = parser.nextRecord();
            Assert.assertNull((Object)record);
            Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        }
    }

    private void validateRecordPosition(String lineSeparator) throws IOException {
        String nl = lineSeparator;
        String code = "a,b,c" + lineSeparator + "1,2,3" + lineSeparator + "'A" + nl + "A','B" + nl + "B',CC" + lineSeparator + "\u00c4,\u00d6,\u00dc" + lineSeparator + "EOF,EOF,EOF";
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\'').withRecordSeparator(lineSeparator);
        CSVParser parser = CSVParser.parse((String)code, (CSVFormat)format);
        Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
        CSVRecord record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(97), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)2L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(49), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        long positionRecord3 = record.getCharacterPosition();
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("'A"), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)("A" + lineSeparator + "A"), (Object)record.get(0));
        Assert.assertEquals((Object)("B" + lineSeparator + "B"), (Object)record.get(1));
        Assert.assertEquals((Object)"CC", (Object)record.get(2));
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)4L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(196), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)5L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("EOF"), (long)record.getCharacterPosition());
        parser.close();
        parser = new CSVParser((Reader)new StringReader(code.substring((int)positionRecord3)), format, positionRecord3, 3L);
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("'A"), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)("A" + lineSeparator + "A"), (Object)record.get(0));
        Assert.assertEquals((Object)("B" + lineSeparator + "B"), (Object)record.get(1));
        Assert.assertEquals((Object)"CC", (Object)record.get(2));
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)4L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(196), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)"\u00c4", (Object)record.get(0));
        parser.close();
    }
}

