/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.perf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class PerformanceTest {
    private final int max = 10;
    private static final File BIG_FILE = new File(System.getProperty("java.io.tmpdir"), "worldcitiespop.txt");

    @BeforeClass
    public static void setUpClass() throws FileNotFoundException, IOException {
        if (BIG_FILE.exists()) {
            System.out.println(String.format("Found test fixture %s: %,d bytes.", BIG_FILE, BIG_FILE.length()));
            return;
        }
        System.out.println("Decompressing test fixture " + BIG_FILE + "...");
        try (GZIPInputStream input = new GZIPInputStream(new FileInputStream("src/test/resources/perf/worldcitiespop.txt.gz"));
             FileOutputStream output = new FileOutputStream(BIG_FILE);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
            System.out.println(String.format("Decompressed test fixture %s: %,d bytes.", BIG_FILE, BIG_FILE.length()));
        }
    }

    private BufferedReader createBufferedReader() throws IOException {
        return new BufferedReader(new FileReader(BIG_FILE));
    }

    private long parse(Reader in, boolean traverseColumns) throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(false);
        long recordCount = 0L;
        for (CSVRecord record : format.parse(in)) {
            ++recordCount;
            if (!traverseColumns) continue;
            for (String string : record) {
            }
        }
        return recordCount;
    }

    private void println(String s) {
        System.out.println(s);
    }

    private long readAll(BufferedReader in) throws IOException {
        long count = 0L;
        while (in.readLine() != null) {
            ++count;
        }
        return count;
    }

    public long testParseBigFile(boolean traverseColumns) throws Exception {
        long startMillis = System.currentTimeMillis();
        long count = this.parse(this.createBufferedReader(), traverseColumns);
        long totalMillis = System.currentTimeMillis() - startMillis;
        this.println(String.format("File parsed in %,d milliseconds with Commons CSV: %,d lines.", totalMillis, count));
        return totalMillis;
    }

    @Test
    public void testParseBigFileRepeat() throws Exception {
        long bestTime = Long.MAX_VALUE;
        for (int i = 0; i < this.max; ++i) {
            bestTime = Math.min(this.testParseBigFile(false), bestTime);
        }
        this.println(String.format("Best time out of %,d is %,d milliseconds.", this.max, bestTime));
    }

    @Test
    public void testReadBigFile() throws Exception {
        long bestTime = Long.MAX_VALUE;
        for (int i = 0; i < this.max; ++i) {
            long count;
            long startMillis;
            try (BufferedReader in = this.createBufferedReader();){
                startMillis = System.currentTimeMillis();
                count = 0L;
                count = this.readAll(in);
            }
            long totalMillis = System.currentTimeMillis() - startMillis;
            bestTime = Math.min(totalMillis, bestTime);
            this.println(String.format("File read in %,d milliseconds: %,d lines.", totalMillis, count));
        }
        this.println(String.format("Best time out of %,d is %,d milliseconds.", this.max, bestTime));
    }
}

