/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.parsing;

import java.io.EOFException;
import java.util.ArrayDeque;

public final class ParserContext {
    private final String input;
    private int startIndex;
    private final ArrayDeque<Integer> snapshots = new ArrayDeque();

    public ParserContext(String input) {
        this.input = input;
        this.startIndex = 0;
    }

    public void snapshot() {
        this.snapshots.push(this.startIndex);
    }

    public void commit() {
        this.snapshots.pop();
    }

    public void revert() {
        this.startIndex = this.snapshots.pop();
    }

    public char peekChar(int offset) throws EOFException {
        if (offset + this.startIndex == this.input.length()) {
            throw new EOFException();
        }
        return this.input.charAt(this.startIndex + offset);
    }

    public char peekCharUnchecked(int offset) {
        return this.input.charAt(this.startIndex + offset);
    }

    public void advance(int amount) {
        this.startIndex += amount;
    }

    public int remainingLength() {
        return this.input.length() - this.startIndex;
    }

    public String chopFront(int length) {
        String retVal = this.input.substring(this.startIndex, this.startIndex + length);
        this.advance(retVal.length());
        return retVal;
    }

    public boolean startsWith(String prefix) {
        return this.input.startsWith(prefix, this.startIndex);
    }

    public int indexOf(char c) {
        int result = this.input.indexOf(c, this.startIndex);
        if (result == -1) {
            return -1;
        }
        return result - this.startIndex;
    }
}

