/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.peephole.ClassMerger;

public class HorizontalClassMerger
implements ClassPoolVisitor {
    private static final int NOT_INSTANTIATED_NO_MEMBERS = 3;
    private static final int NOT_INSTANTIATED_WITH_MEMBERS = 2;
    private static final int INSTANTIATED_NO_MEMBERS = 1;
    private static final int INSTANTIATED_WITH_MEMBERS = 0;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final ClassVisitor extraClassVisitor;
    private final Set<String> forbiddenClassNames;

    public HorizontalClassMerger(boolean allowAccessModification, boolean mergeInterfacesAggressively, Set<String> forbiddenClassNames) {
        this(allowAccessModification, mergeInterfacesAggressively, forbiddenClassNames, null);
    }

    public HorizontalClassMerger(boolean allowAccessModification, boolean mergeInterfacesAggressively, Set<String> forbiddenClassNames, ClassVisitor extraClassVisitor) {
        this.allowAccessModification = allowAccessModification;
        this.mergeInterfacesAggressively = mergeInterfacesAggressively;
        this.forbiddenClassNames = forbiddenClassNames;
        this.extraClassVisitor = extraClassVisitor;
    }

    public void visitClassPool(ClassPool classPool) {
        Map<Clazz, List<Clazz>> siblingsCollections = StreamSupport.stream(classPool.classes().spliterator(), false).filter(this::isCandidateForMerging).collect(Collectors.groupingBy(Clazz::getSuperClass));
        siblingsCollections.values().forEach(this::handleSiblings);
    }

    private void handleSiblings(List<Clazz> classes) {
        Map<Integer, List<Clazz>> partition = classes.stream().collect(Collectors.groupingBy(HorizontalClassMerger::classify));
        List<Clazz> notInstantiatedNoMembers = partition.getOrDefault(3, Collections.emptyList());
        List<Clazz> notInstantiatedWithMembers = partition.getOrDefault(2, Collections.emptyList());
        List<Clazz> instantiatedNoMembers = partition.getOrDefault(1, Collections.emptyList());
        this.mergeInto(classes, notInstantiatedNoMembers);
        this.mergeInto(notInstantiatedWithMembers, notInstantiatedWithMembers);
        this.mergeInto(instantiatedNoMembers, instantiatedNoMembers);
    }

    private void mergeInto(List<Clazz> sourceClasses, List<Clazz> targetClasses) {
        for (Clazz target : targetClasses) {
            ClassMerger classMerger = new ClassMerger((ProgramClass)target, this.allowAccessModification, this.mergeInterfacesAggressively, false, this.extraClassVisitor);
            for (Clazz source : sourceClasses) {
                source.accept((ClassVisitor)classMerger);
            }
        }
    }

    public boolean isCandidateForMerging(Clazz clazz) {
        return !KeepMarker.isKept(clazz) && ClassMerger.getTargetClass(clazz) == null && !(clazz instanceof LibraryClass) && !ClassMerger.hasSignatureAttribute(clazz) && !DotClassMarker.isDotClassed(clazz) && (clazz.getAccessFlags() & 0x2000) == 0 && (clazz.getProcessingFlags() & 0x200) == 0 && !this.forbiddenClassNames.contains(clazz.getName()) && clazz.getSuperClass() != null;
    }

    private static Integer classify(Clazz clazz) {
        boolean hasMembers;
        boolean isInstantiated = InstantiationClassMarker.isInstantiated(clazz) || ((ProgramClass)clazz).subClassCount > 0;
        MemberCounter counter = new MemberCounter();
        clazz.fieldsAccept((MemberVisitor)new MemberAccessFilter(0, 8, (MemberVisitor)counter));
        boolean bl = hasMembers = counter.getCount() > 0;
        if (isInstantiated) {
            if (hasMembers) {
                return 0;
            }
            return 1;
        }
        if (hasMembers) {
            return 2;
        }
        return 3;
    }
}

