/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumUseChecker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
ConstantVisitor,
InstructionVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final PartialEvaluator partialEvaluator;
    private final MemberVisitor methodCodeChecker = new AllAttributeVisitor((AttributeVisitor)this);
    private final ConstantVisitor invokedMethodChecker = new ReferencedMemberVisitor((MemberVisitor)this);
    private final ConstantVisitor parameterChecker = new ReferencedMemberVisitor((MemberVisitor)new AllParameterVisitor(false, (ParameterVisitor)this));
    private final ClassVisitor complexEnumMarker = new OptimizationInfoClassFilter(new SimpleEnumMarker(false));
    private final ReferencedClassVisitor referencedComplexEnumMarker = new ReferencedClassVisitor(this.complexEnumMarker);
    private int invocationOffset;

    public SimpleEnumUseChecker() {
        this(new PartialEvaluator((ValueFactory)new TypedReferenceValueFactory()));
    }

    public SimpleEnumUseChecker(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.attributesAccept((AttributeVisitor)this);
        if ((programClass.getAccessFlags() & 0x2000) != 0) {
            programClass.methodsAccept((MemberVisitor)this.referencedComplexEnumMarker);
        } else {
            programClass.methodsAccept(this.methodCodeChecker);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, (BootstrapMethodInfoVisitor)this);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this);
            if (!this.partialEvaluator.isBranchOrExceptionTarget(offset)) continue;
            this.checkMixedStackEntriesBefore(offset);
            this.checkMixedVariablesBefore(offset);
        }
    }

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        bootstrapMethodInfo.methodHandleAccept(clazz, (ConstantVisitor)this);
        bootstrapMethodInfo.methodArgumentsAccept(clazz, (ConstantVisitor)this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedClassAccept(this.complexEnumMarker);
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.referenceAccept(clazz, (ConstantVisitor)this);
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.referencedClassesAccept((ClassVisitor)this.referencedComplexEnumMarker);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.referencedClassAccept((ClassVisitor)this.referencedComplexEnumMarker);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this.complexEnumMarker);
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                if (this.isPoppingSimpleEnumType(offset, 2)) break;
                this.markPoppedComplexEnumType(offset);
                break;
            }
            case -80: {
                if (this.isReturningSimpleEnumType(clazz, method)) break;
                this.markPoppedComplexEnumType(offset);
                break;
            }
            case -62: 
            case -61: {
                this.markPoppedComplexEnumType(offset);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -77: 
            case -75: {
                this.invocationOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -74: {
                String invokedMethodName = clazz.getRefName(constantInstruction.constantIndex);
                String invokedMethodType = clazz.getRefType(constantInstruction.constantIndex);
                int stackEntryIndex = ClassUtil.internalMethodParameterSize((String)invokedMethodType);
                if (this.isPoppingSimpleEnumType(offset, stackEntryIndex) && !this.isSupportedMethod(invokedMethodName, invokedMethodType)) {
                    this.markPoppedComplexEnumType(offset, stackEntryIndex);
                }
                this.invocationOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -73: 
            case -72: 
            case -71: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.invokedMethodChecker);
                this.invocationOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -64: 
            case -63: {
                if (this.isPoppingExpectedType(offset, clazz, constantInstruction.constantIndex)) break;
                this.markPoppedComplexEnumType(offset);
                if (constantInstruction.opcode == -64 && this.isSimpleEnum(clazz) && (method.getAccessFlags() & 8) != 0 && this.isMethodSkippedForCheckcast(method.getName(clazz), method.getDescriptor(clazz))) break;
                this.markConstantComplexEnumType(clazz, constantInstruction.constantIndex);
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -91: 
            case -90: {
                if (this.isPoppingIdenticalTypes(offset, 0, 1)) break;
                this.markPoppedComplexEnumType(offset, 0);
                this.markPoppedComplexEnumType(offset, 1);
            }
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.isSimpleEnum((Clazz)programClass) && this.isUnsupportedMethod(programMethod.getName((Clazz)programClass), programMethod.getDescriptor((Clazz)programClass))) {
            this.complexEnumMarker.visitProgramClass(programClass);
        }
    }

    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        int stackEntryIndex = parameterSize - parameterOffset - 1;
        if (ClassUtil.isInternalClassType((String)parameterType) && !this.isPoppingExpectedType(this.invocationOffset, stackEntryIndex, ClassUtil.isInternalArrayType((String)parameterType) ? parameterType : ClassUtil.internalClassNameFromClassType((String)parameterType))) {
            this.markPoppedComplexEnumType(this.invocationOffset, stackEntryIndex);
        }
    }

    private boolean isSupportedMethod(String name, String type) {
        return name.equals("ordinal") && type.equals("()I") || name.equals("clone") && type.equals("()Ljava/lang/Object;");
    }

    private boolean isUnsupportedMethod(String name, String type) {
        return name.equals("valueOf");
    }

    private boolean isMethodSkippedForCheckcast(String name, String type) {
        return name.equals("valueOf") || name.equals("values");
    }

    private void checkMixedStackEntriesBefore(int offset) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(offset);
        int stackSize = stackBefore.size();
        for (int stackEntryIndex = 0; stackEntryIndex < stackSize; ++stackEntryIndex) {
            ReferenceValue consumedStackEntry;
            InstructionOffsetValue producerOffsets;
            int producerCount;
            Value stackEntry = stackBefore.getBottom(stackEntryIndex);
            if (stackEntry.computationalType() != 5 || (producerCount = (producerOffsets = stackBefore.getBottomActualProducerValue(stackEntryIndex).instructionOffsetValue()).instructionOffsetCount()) <= 1 || this.isSimpleEnumType(consumedStackEntry = stackEntry.referenceValue())) continue;
            for (int producerIndex = 0; producerIndex < producerCount; ++producerIndex) {
                if (producerOffsets.isExceptionHandler(producerIndex)) continue;
                int producerOffset = producerOffsets.instructionOffset(producerIndex);
                this.markPushedComplexEnumType(producerOffset);
            }
        }
    }

    private void checkMixedVariablesBefore(int offset) {
        TracedVariables variablesBefore = this.partialEvaluator.getVariablesBefore(offset);
        int variablesSize = variablesBefore.size();
        for (int variableIndex = 0; variableIndex < variablesSize; ++variableIndex) {
            ReferenceValue consumedVariable;
            InstructionOffsetValue producerOffsets;
            int producerCount;
            Value variable = variablesBefore.getValue(variableIndex);
            if (variable == null || variable.computationalType() != 5 || (producerCount = (producerOffsets = variablesBefore.getProducerValue(variableIndex).instructionOffsetValue()).instructionOffsetCount()) <= 1 || this.isSimpleEnumType(consumedVariable = variable.referenceValue())) continue;
            for (int producerIndex = 0; producerIndex < producerCount; ++producerIndex) {
                if (producerOffsets.isMethodParameter(producerIndex)) continue;
                int producerOffset = producerOffsets.instructionOffset(producerIndex);
                this.markStoredComplexEnumType(producerOffset, variableIndex);
            }
        }
    }

    private boolean isPoppingIdenticalTypes(int offset, int stackEntryIndex1, int stackEntryIndex2) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(offset);
        String type1 = stackBefore.getTop(stackEntryIndex1).referenceValue().getType();
        String type2 = stackBefore.getTop(stackEntryIndex2).referenceValue().getType();
        return type1 == null ? type2 == null : type1.equals(type2);
    }

    private boolean isPoppingExpectedType(int offset, Clazz clazz, int constantIndex) {
        return this.isPoppingExpectedType(offset, 0, clazz, constantIndex);
    }

    private boolean isPoppingExpectedType(int offset, int stackEntryIndex, Clazz clazz, int constantIndex) {
        return this.isPoppingExpectedType(offset, stackEntryIndex, clazz.getClassName(constantIndex));
    }

    private boolean isPoppingExpectedType(int offset, int stackEntryIndex, String expectedType) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(offset);
        String poppedType = stackBefore.getTop(stackEntryIndex).referenceValue().getType();
        return expectedType.equals(poppedType);
    }

    private boolean isReturningSimpleEnumType(Clazz clazz, Method method) {
        Clazz[] referencedClasses;
        String descriptor = method.getDescriptor(clazz);
        String returnType = ClassUtil.internalMethodReturnType((String)descriptor);
        if (ClassUtil.isInternalClassType((String)returnType) && (referencedClasses = ((ProgramMethod)method).referencedClasses) != null) {
            Clazz referencedClass = referencedClasses[referencedClasses.length - 1];
            return this.isSimpleEnum(referencedClass);
        }
        return false;
    }

    private boolean isPoppingSimpleEnumType(int offset) {
        return this.isPoppingSimpleEnumType(offset, 0);
    }

    private boolean isPoppingSimpleEnumType(int offset, int stackEntryIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(offset).getTop(stackEntryIndex).referenceValue();
        return this.isSimpleEnumType(referenceValue);
    }

    private boolean isSimpleEnumType(ReferenceValue referenceValue) {
        return this.isSimpleEnum(referenceValue.getReferencedClass());
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }

    private void markConstantComplexEnumType(Clazz clazz, int constantIndex) {
        clazz.constantPoolEntryAccept(constantIndex, (ConstantVisitor)this.referencedComplexEnumMarker);
    }

    private void markPoppedComplexEnumType(int offset) {
        this.markPoppedComplexEnumType(offset, 0);
    }

    private void markPoppedComplexEnumType(int offset, int stackEntryIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(offset).getTop(stackEntryIndex).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markPushedComplexEnumType(int offset) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackAfter(offset).getTop(0).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markStoredComplexEnumType(int offset, int variableIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getVariablesAfter(offset).getValue(variableIndex).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markComplexEnumType(ReferenceValue referenceValue) {
        Clazz clazz = referenceValue.getReferencedClass();
        if (clazz != null) {
            clazz.accept(this.complexEnumMarker);
        }
    }
}

