/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.SimpleClassPrinter;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;

public class SeedPrinter {
    private final PrintWriter printWriter;

    public SeedPrinter(PrintWriter printWriter) throws IOException {
        this.printWriter = printWriter;
    }

    public void write(Configuration configuration, ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options if you want to write out kept elements with '-printseeds'.");
        }
        programClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        libraryClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(true, true, true).createClassPoolVisitor(configuration.keep, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, null);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        SimpleClassPrinter printer = new SimpleClassPrinter(false, this.printWriter);
        programClassPool.classesAcceptAlphabetically((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new KeptClassFilter((ClassVisitor)printer), new AllMemberVisitor((MemberVisitor)new KeptMemberFilter((MemberVisitor)printer))}));
    }
}

