/*
 * Decompiled with CFR 0.152.
 */
package com.gsconrad.richcontentedittext;

import android.content.ClipDescription;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v13.view.inputmethod.EditorInfoCompat;
import android.support.v13.view.inputmethod.InputConnectionCompat;
import android.support.v13.view.inputmethod.InputContentInfoCompat;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.util.Log;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import com.gsconrad.richcontentedittext.R;

public class RichContentEditText
extends AppCompatEditText {
    private OnRichContentListener onRichContentListener = null;
    private String[] mimeTypes = new String[0];
    private static final String TAG = "RichContentEditText";
    public boolean runListenerInBackground = true;

    public RichContentEditText(Context context) {
        super(context);
    }

    public RichContentEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAttributes(context, attrs);
    }

    public RichContentEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setAttributes(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RichContentEditText, 0, 0);
        try {
            switch (a.getInteger(R.styleable.RichContentEditText_allowedMimeTypes, 0)) {
                case 0: {
                    this.disallowRichContent();
                    return;
                }
                case 1: {
                    this.allowImageInsertion();
                    return;
                }
                default: {
                    this.disallowRichContent();
                    return;
                }
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setOnRichContentListener(OnRichContentListener onRichContentListener) {
        this.onRichContentListener = onRichContentListener;
    }

    public void setContentMimeTypes(String[] mimeTypes) {
        if (mimeTypes != null) {
            this.mimeTypes = mimeTypes;
        }
    }

    public void allowImageInsertion() {
        this.setContentMimeTypes(new String[]{"image/*", "image/png", "image/gif", "image/jpeg"});
    }

    public void disallowRichContent() {
        this.setContentMimeTypes(new String[0]);
    }

    public String[] getContentMimeTypes() {
        return this.mimeTypes;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection ic = super.onCreateInputConnection(editorInfo);
        EditorInfoCompat.setContentMimeTypes((EditorInfo)editorInfo, (String[])this.getContentMimeTypes());
        return InputConnectionCompat.createWrapper((InputConnection)ic, (EditorInfo)editorInfo, (InputConnectionCompat.OnCommitContentListener)new InputConnectionCompat.OnCommitContentListener(){

            public boolean onCommitContent(final InputContentInfoCompat inputContentInfo, int flags, Bundle opts) {
                if (Build.VERSION.SDK_INT >= 25 && (flags & InputConnectionCompat.INPUT_CONTENT_GRANT_READ_URI_PERMISSION) != 0) {
                    try {
                        if (RichContentEditText.this.onRichContentListener != null) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    inputContentInfo.requestPermission();
                                    RichContentEditText.this.onRichContentListener.onRichContent(inputContentInfo.getContentUri(), inputContentInfo.getDescription());
                                    inputContentInfo.releasePermission();
                                }
                            };
                            if (RichContentEditText.this.runListenerInBackground) {
                                new Thread(runnable).start();
                            } else {
                                runnable.run();
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)RichContentEditText.TAG, (String)("Error accepting rich content: " + e.getMessage()));
                        e.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public static interface OnRichContentListener {
        public void onRichContent(Uri var1, ClipDescription var2);
    }
}

