/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.subsumption;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.Pair;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeBooleanMutator;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeEmptyMutator;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeMutator;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeNullMutator;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeZeroMutator;
import com.groupcdg.arcmutate.mutators.reactive.ReactiveReturnsMutator;
import com.groupcdg.arcmutate.mutators.removal.stream.RemoveFilterMutator;
import com.groupcdg.arcmutate.subsumption.MutationLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.mutators.ConditionalsBoundaryMutator;
import org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanTrueReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.NullReturnValsMutator;

class SubsumptionInterceptor
extends AnalysingInterceptor {
    SubsumptionInterceptor() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.MODIFY_COSMETIC;
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        ArrayList<MutationDetails> toReturn = new ArrayList<MutationDetails>(mutants);
        toReturn.removeAll(this.removeLessStableExtremeNullMutations(toReturn));
        toReturn.removeAll(this.removeExtremeMutantsWhenOthersPresent(toReturn));
        toReturn.removeAll(this.removeConditionalSubsumedByReturnTrueInSimpleMethods(toReturn));
        toReturn.removeAll(this.trueReturnsSubsumedByRemoveFilter(toReturn));
        toReturn.removeAll(this.removeConditionalsSubsumedByConditionalBoundary(toReturn));
        toReturn.removeAll(this.nullReturnsSubsumedByReactiveReturns(toReturn));
        toReturn.removeAll(this.removeFiltersSubsumedByTrueReturnOfMethodReference(toReturn));
        toReturn.removeAll(this.lambdaReturnsSubsumedByReturnOfMethodTheyThinlyWrap(toReturn));
        return toReturn.stream();
    }

    private List<MutationDetails> removeLessStableExtremeNullMutations(List<MutationDetails> mutants) {
        return this.removeWhenInSameMethod(this.isFrom(ExtremeNullMutator.EXTREME_NULL), this.isFrom(Arrays.asList(ExtremeEmptyMutator.EXTREME_EMPTY, ExtremeBooleanMutator.EXTREME_BOOLEAN, ExtremeZeroMutator.EXTREME_ZERO)), mutants);
    }

    private List<MutationDetails> removeExtremeMutantsWhenOthersPresent(List<MutationDetails> mutants) {
        return this.removeWhenInSameMethod(m -> ExtremeMutator.isExtreme(m.getMutator()), m -> !ExtremeMutator.isExtreme(m.getMutator()), mutants);
    }

    private List<MutationDetails> nullReturnsSubsumedByReactiveReturns(List<MutationDetails> mutants) {
        return this.removeWhenInSameMethod(this.isFrom((MethodMutatorFactory)NullReturnValsMutator.NULL_RETURNS), this.isFrom(ReactiveReturnsMutator.REACTIVE_RETURNS), mutants);
    }

    private List<MutationDetails> removeFiltersSubsumedByTrueReturnOfMethodReference(Collection<MutationDetails> mutants) {
        Map<Optional, List<MutationDetails>> filterMutants = mutants.stream().filter(this.isFrom(RemoveFilterMutator.REMOVE_FILTER)).collect(Collectors.groupingBy(this::filterMethod));
        Set mutatedReturns = mutants.stream().filter(this.isFrom((MethodMutatorFactory)BooleanTrueReturnValsMutator.TRUE_RETURNS)).map(m -> m.getId().getLocation()).collect(Collectors.toSet());
        return filterMutants.entrySet().stream().filter(e -> ((Optional)e.getKey()).isPresent()).filter(e -> mutatedReturns.contains(((Optional)e.getKey()).get())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    private Optional<Location> filterMethod(MutationDetails mutant) {
        Optional<MethodTree> maybeMethod = this.mutatedMethod(mutant);
        if (!maybeMethod.isPresent()) {
            return Optional.empty();
        }
        AbstractInsnNode filterParam = maybeMethod.get().realInstructionBefore(mutant.getInstructionIndex());
        if (filterParam instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode call = (InvokeDynamicInsnNode)filterParam;
            Handle h = (Handle)call.bsmArgs[1];
            return Optional.of(Location.location((ClassName)ClassName.fromString((String)h.getOwner()), (String)h.getName(), (String)h.getDesc()));
        }
        return Optional.empty();
    }

    private List<MutationDetails> removeConditionalsSubsumedByConditionalBoundary(Collection<MutationDetails> mutants) {
        Map<Integer, List<MutationDetails>> byLineNumber = mutants.stream().filter(this.isFrom((MethodMutatorFactory)ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY).or(this.isFrom(RemoveConditionalMutator.factory()))).collect(Collectors.groupingBy(MutationDetails::getLineNumber));
        return byLineNumber.entrySet().stream().flatMap(this::subsumedConditionals).collect(Collectors.toList());
    }

    private Stream<MutationDetails> subsumedConditionals(Map.Entry<Integer, List<MutationDetails>> mutants) {
        Set mutatedBoundaries = mutants.getValue().stream().filter(this.isFrom((MethodMutatorFactory)ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY)).map(m -> new MutationLocation(m.getId().getLocation(), m.getInstructionIndex())).collect(Collectors.toSet());
        return mutants.getValue().stream().filter(this.isFrom((MethodMutatorFactory)ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY).negate()).filter(m -> mutatedBoundaries.contains(new MutationLocation(m.getId().getLocation(), m.getInstructionIndex()))).filter(this::subsumedByBoundaryMutation);
    }

    private boolean subsumedByBoundaryMutation(MutationDetails mutant) {
        Optional<MethodTree> maybeMethod = this.mutatedMethod(mutant);
        if (!maybeMethod.isPresent()) {
            return false;
        }
        AbstractInsnNode mutated = maybeMethod.get().instruction(mutant.getInstructionIndex());
        switch (mutated.getOpcode()) {
            case 156: 
            case 158: 
            case 162: 
            case 164: {
                return this.isFrom("org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator_ORDER_IF").test(mutant);
            }
            case 155: 
            case 157: 
            case 161: 
            case 163: {
                return this.isFrom("org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator_ORDER_ELSE").test(mutant);
            }
        }
        return false;
    }

    private List<MutationDetails> trueReturnsSubsumedByRemoveFilter(Collection<MutationDetails> mutants) {
        Map<Integer, List<MutationDetails>> byLineNumber = mutants.stream().filter(this.isFrom((MethodMutatorFactory)BooleanTrueReturnValsMutator.TRUE_RETURNS).or(this.isFrom(RemoveFilterMutator.REMOVE_FILTER))).collect(Collectors.groupingBy(MutationDetails::getLineNumber));
        return byLineNumber.entrySet().stream().flatMap(this::subsumedReturns).collect(Collectors.toList());
    }

    private Stream<MutationDetails> subsumedReturns(Map.Entry<Integer, List<MutationDetails>> mutants) {
        List<MutationDetails> removeFilters = mutants.getValue().stream().filter(this.isFrom(RemoveFilterMutator.REMOVE_FILTER)).collect(Collectors.toList());
        return mutants.getValue().stream().filter(this.isFrom((MethodMutatorFactory)BooleanTrueReturnValsMutator.TRUE_RETURNS)).filter(this.isLambdaForMethod(removeFilters));
    }

    private List<MutationDetails> lambdaReturnsSubsumedByReturnOfMethodTheyThinlyWrap(List<MutationDetails> mutants) {
        List returnMutants = mutants.stream().filter(this::mutatesReturn).collect(Collectors.toList());
        List lambdaReturnMutants = returnMutants.stream().filter(m -> m.getMethod().startsWith("lambda$")).flatMap(this::toDestinationMutantPair).collect(Collectors.toList());
        if (lambdaReturnMutants.isEmpty()) {
            return Collections.emptyList();
        }
        List nonLambdaReturns = returnMutants.stream().filter(m -> !m.getMethod().startsWith("lambda$")).flatMap(this::toMutatedMethodLocation).collect(Collectors.toList());
        Map<Location, List<MutationDetails>> map = nonLambdaReturns.stream().collect(Collectors.groupingBy(Pair::first, Collectors.mapping(p -> (MutationDetails)p.second(), Collectors.toList())));
        return lambdaReturnMutants.stream().filter(this.hasMatchingMethodMutation(map)).map(Pair::second).collect(Collectors.toList());
    }

    private List<MutationDetails> removeConditionalSubsumedByReturnTrueInSimpleMethods(List<MutationDetails> mutants) {
        Map<Integer, List<MutationDetails>> byLineNumber = mutants.stream().filter(this.isFrom((MethodMutatorFactory)BooleanTrueReturnValsMutator.TRUE_RETURNS).or(this.isFrom("org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator_EQUAL_IF"))).collect(Collectors.groupingBy(MutationDetails::getLineNumber));
        return byLineNumber.entrySet().stream().filter(m -> ((List)m.getValue()).size() == 2).flatMap(m -> ((List)m.getValue()).stream()).filter(this.isFrom("org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator_EQUAL_IF")).collect(Collectors.toList());
    }

    private Predicate<Pair<Location, MutationDetails>> hasMatchingMethodMutation(Map<Location, List<MutationDetails>> map) {
        return p -> map.getOrDefault(p.first(), Collections.emptyList()).stream().anyMatch(m -> ((MutationDetails)p.second()).getId().getMutator().equals(m.getId().getMutator()));
    }

    private Stream<Pair<Location, MutationDetails>> toMutatedMethodLocation(MutationDetails mutationDetails) {
        Optional<MethodTree> maybeMethod = this.mutatedMethod(mutationDetails);
        if (!maybeMethod.isPresent()) {
            return Stream.empty();
        }
        Location loc = maybeMethod.get().asLocation();
        return Stream.of(new Pair<Location, MutationDetails>(loc, mutationDetails));
    }

    private Stream<Pair<Location, MutationDetails>> toDestinationMutantPair(MutationDetails mutationDetails) {
        Optional<MethodTree> maybeMethod = this.mutatedMethod(mutationDetails);
        if (!maybeMethod.isPresent()) {
            return Stream.empty();
        }
        MethodTree method = maybeMethod.get();
        List calls = method.instructions().stream().filter(node -> node instanceof MethodInsnNode).map(MethodInsnNode.class::cast).filter(call -> call.owner.equals(mutationDetails.getClassName().asInternalName())).collect(Collectors.toList());
        if (calls.size() != 1 || this.hasBehaviour(method.instructions())) {
            return Stream.empty();
        }
        MethodInsnNode call2 = (MethodInsnNode)calls.get(0);
        int callIndex = method.instructions().indexOf(call2);
        if (method.instructions().stream().skip(callIndex + 1).filter(node -> node instanceof MethodInsnNode).map(MethodInsnNode.class::cast).anyMatch(this.isAutoBoxing().negate())) {
            return Stream.empty();
        }
        Location l = Location.location((ClassName)ClassName.fromString((String)call2.owner), (String)call2.name, (String)call2.desc);
        return Stream.of(new Pair<Location, MutationDetails>(l, mutationDetails));
    }

    private Predicate<MethodInsnNode> isAutoBoxing() {
        return call -> call.owner.startsWith("java/lang") && call.name.equals("valueOf");
    }

    private boolean hasBehaviour(List<AbstractInsnNode> instructions) {
        return instructions.stream().filter(n -> !(n instanceof LabelNode)).filter(n -> !(n instanceof LineNumberNode)).filter(n -> !(n instanceof MethodInsnNode)).anyMatch(this.simpleLoad().or(this.dup()).or(this.isReturn()).negate());
    }

    private Predicate<AbstractInsnNode> dup() {
        return this.inclusiveRange(89, 94);
    }

    private Predicate<AbstractInsnNode> simpleLoad() {
        return this.inclusiveRange(1, 53);
    }

    private Predicate<AbstractInsnNode> isReturn() {
        return this.inclusiveRange(172, 176);
    }

    private Predicate<AbstractInsnNode> inclusiveRange(int start, int end) {
        return n -> n.getOpcode() >= start && n.getOpcode() <= end;
    }

    private boolean mutatesReturn(MutationDetails mutationDetails) {
        Optional<MethodTree> maybeMethod = this.mutatedMethod(mutationDetails);
        if (!maybeMethod.isPresent()) {
            return false;
        }
        AbstractInsnNode node = maybeMethod.get().instruction(mutationDetails.getInstructionIndex());
        return this.isReturn().test(node);
    }

    private Predicate<MutationDetails> isLambdaForMethod(List<MutationDetails> removeFilters) {
        return m -> removeFilters.stream().anyMatch(l -> m.getMethod().startsWith("lambda$" + l.getMethod()));
    }

    private Predicate<MutationDetails> isFrom(MethodMutatorFactory a) {
        return this.isFrom(a.getGloballyUniqueId());
    }

    private Predicate<MutationDetails> isFrom(String id) {
        return m -> m.getId().getMutator().equals(id);
    }

    private Predicate<MutationDetails> isFrom(Iterable<MethodMutatorFactory> a) {
        Set ids = StreamSupport.stream(a.spliterator(), false).map(f -> f.getGloballyUniqueId()).collect(Collectors.toSet());
        return m -> ids.contains(m.getId().getMutator());
    }

    private List<MutationDetails> removeWhenInSameMethod(Predicate<MutationDetails> subsumed, Predicate<MutationDetails> by, List<MutationDetails> mutants) {
        Map<Location, List<MutationDetails>> lessStable = mutants.stream().filter(subsumed).collect(Collectors.groupingBy(m -> m.getId().getLocation()));
        Map<Location, List<MutationDetails>> moreStable = mutants.stream().filter(by).collect(Collectors.groupingBy(m -> m.getId().getLocation()));
        return lessStable.entrySet().stream().filter(e -> moreStable.containsKey(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }
}

