/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal.fields;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.removal.fields.RemoveFieldWriteMutator;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.engine.MutationDetails;

class JunkFieldRemovalInterceptor
extends AnalysingInterceptor {
    JunkFieldRemovalInterceptor() {
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        return mutants.stream().filter(this.isJunkFieldWriteMutant().negate());
    }

    private Predicate<MutationDetails> isJunkFieldWriteMutant() {
        return this.isFor(RemoveFieldWriteMutator.FIELD_WRITES).and(this::isJunk);
    }

    private boolean isJunk(MutationDetails mutant) {
        Optional maybeMethod = this.currentClass.method(mutant.getId().getLocation());
        if (!maybeMethod.isPresent()) {
            return false;
        }
        MethodTree method = (MethodTree)maybeMethod.get();
        AbstractInsnNode instruction = method.instruction(mutant.getInstructionIndex());
        FieldInsnNode call = (FieldInsnNode)instruction;
        return this.isFinalField(call);
    }

    private boolean isFinalField(FieldInsnNode call) {
        return this.currentClass.rawNode().fields.stream().anyMatch(f -> f.name.equals(call.name) && Modifier.isFinal(f.access));
    }
}

