/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal;

import com.groupcdg.arcmutate.mutators.MethodLocation;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public class RemoveCallVisitor
extends MethodVisitor {
    private final Predicate<MethodLocation> target;
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    public RemoveCallVisitor(MutationContext context, MethodVisitor writer, Predicate<MethodLocation> target, MethodMutatorFactory factory) {
        super(589824, writer);
        this.target = target;
        this.factory = factory;
        this.context = context;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MutationIdentifier newId;
        MethodLocation location = MethodLocation.location(ClassName.fromString((String)owner), name, desc);
        if (this.isNotStatic(opcode) && this.target.test(location) && this.context.shouldMutate(newId = this.context.registerMutation(this.factory, "removed call to " + this.describe(location)))) {
            this.popMethodArgumentsFromStack(desc);
            return;
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private String describe(MethodLocation location) {
        return location.methodName();
    }

    private void popMethodArgumentsFromStack(String desc) {
        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
        for (int i = argumentTypes.length; i != 0; --i) {
            this.popArgument(argumentTypes[i - 1]);
        }
    }

    private void popArgument(Type argumentType) {
        if (argumentType.getSize() != 1) {
            this.mv.visitInsn(88);
        } else {
            this.mv.visitInsn(87);
        }
    }

    private boolean isNotStatic(int opcode) {
        return 184 != opcode;
    }
}

