/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.extreme;

import com.groupcdg.arcmutate.mutators.bytecode.Replacement;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeMutator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;

public class ExtremeMutationFilter
implements MutationInterceptor {
    private final Map<String, Boolean> extremeMutators = new ConcurrentHashMap<String, Boolean>();
    private final SequenceMatcher<AbstractInsnNode> equivalent = Replacement.generateFilter().or(this.arrays()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));
    private ClassTree clazz;

    private SequenceQuery<AbstractInsnNode> arrays() {
        return QueryStart.match((Match)OpcodeMatchers.ICONST_0).zeroOrMore(QueryStart.match((Match)OpcodeMatchers.ICONST_0)).then(OpcodeMatchers.ANEWARRAY.or(OpcodeMatchers.NEWARRAY).or(OpcodeMatchers.MULTIANEWARRAY)).then(OpcodeMatchers.ARETURN);
    }

    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree classTree) {
        this.clazz = classTree;
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> collection, Mutater mutater) {
        return collection.stream().filter(this::shouldKeep).collect(Collectors.toList());
    }

    private boolean shouldKeep(MutationDetails md) {
        boolean isExtreme = this.extremeMutators.computeIfAbsent(md.getId().getMutator(), ExtremeMutator::isExtreme);
        if (!isExtreme) {
            return true;
        }
        Optional maybeMethod = this.clazz.method(md.getId().getLocation());
        if (!maybeMethod.isPresent()) {
            return true;
        }
        return !this.equivalent.matches(((MethodTree)maybeMethod.get()).instructions());
    }

    public void end() {
        this.clazz = null;
    }
}

