/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.bytecode;

import org.pitest.bytecode.ASMVersion;
import org.pitest.classinfo.ClassName;
import org.pitest.reloc.asm.MethodVisitor;

class ASMToReturnValue
extends MethodVisitor {
    private String method;
    private String val;

    ASMToReturnValue() {
        super(ASMVersion.asmVersion());
    }

    public void visitLdcInsn(Object value) {
        this.val = "\"\"";
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 3: 
            case 9: {
                this.val = "0";
                break;
            }
            case 14: {
                this.val = "0.0d";
                break;
            }
            case 11: {
                this.val = "0.0f";
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.method = ClassName.fromString((String)owner).getNameWithoutPackage().asJavaName() + "." + name;
    }

    public String returnDescription() {
        if (this.val != null) {
            return this.val;
        }
        if (this.method != null) {
            return this.method + "()";
        }
        return null;
    }
}

