/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;
import org.pitest.reloc.asm.Type;

public final class UnifiedType {
    public static final UnifiedType ANY = new UnifiedType("!any!");
    public static final UnifiedType VOID = new UnifiedType("V");
    public static final UnifiedType BOOLEAN = new UnifiedType("Z");
    public static final UnifiedType BYTE = new UnifiedType("B");
    public static final UnifiedType CHAR = new UnifiedType("C");
    public static final UnifiedType SHORT = new UnifiedType("S");
    public static final UnifiedType INT = new UnifiedType("I");
    public static final UnifiedType LONG = new UnifiedType("J");
    public static final UnifiedType DOUBLE = new UnifiedType("D");
    public static final UnifiedType FLOAT = new UnifiedType("F");
    public static final UnifiedType FLUX = UnifiedType.object(ClassName.fromString((String)"reactor.core.publisher.Flux"));
    public static final UnifiedType MONO = UnifiedType.object(ClassName.fromString((String)"reactor.core.publisher.Mono"));
    public static final UnifiedType RX2_MAYBE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.Maybe"));
    public static final UnifiedType RX2_OBSERVABLE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.Observable"));
    public static final UnifiedType RX2_FLOWABLE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.Flowable"));
    public static final UnifiedType RX2_PREDICATE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.functions.Predicate"));
    public static final UnifiedType RX3_MAYBE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.rxjava3.core.Maybe"));
    public static final UnifiedType RX3_OBSERVABLE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.rxjava3.core.Observable"));
    public static final UnifiedType RX3_FLOWABLE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.rxjava3.core.Flowable"));
    public static final UnifiedType RX3_PREDICATE = UnifiedType.object(ClassName.fromString((String)"io.reactivex.rxjava3.functions.Predicate"));
    public static final UnifiedType GUAVA_OPTIONAL = UnifiedType.object(ClassName.fromString((String)"com.google.common.base.Optional"));
    private static final Map<UnifiedType, UnifiedType> predicateSpecializations = UnifiedType.predicates();
    private static final Map<UnifiedType, UnifiedType> streamSpecializations = UnifiedType.streams();
    private final String symbol;

    private UnifiedType(String symbol) {
        this.symbol = symbol;
    }

    public static UnifiedType object(Class<?> type) {
        return UnifiedType.object(ClassName.fromClass(type));
    }

    public static UnifiedType object(ClassName name) {
        return new UnifiedType("L" + name.asInternalName() + ";");
    }

    public static UnifiedType specializeStream(UnifiedType specialization) {
        return streamSpecializations.getOrDefault(specialization, UnifiedType.object(Stream.class));
    }

    public static UnifiedType specializePredicate(UnifiedType specialization) {
        return predicateSpecializations.getOrDefault(specialization, UnifiedType.object(Predicate.class));
    }

    public static List<UnifiedType> specializations() {
        ArrayList<UnifiedType> l = new ArrayList<UnifiedType>(streamSpecializations.keySet());
        l.add(UnifiedType.object(Object.class));
        return l;
    }

    public static UnifiedType parseMethodDescriptor(String methodDescriptor) {
        Type type = Type.getReturnType((String)methodDescriptor);
        return UnifiedType.pickType(type);
    }

    private static UnifiedType pickType(Type type) {
        switch (type.getSort()) {
            case 0: {
                return VOID;
            }
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return CHAR;
            }
            case 3: {
                return BYTE;
            }
            case 4: {
                return SHORT;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return DOUBLE;
            }
            case 10: {
                return UnifiedType.object(ClassName.fromString((String)type.getClassName()));
            }
        }
        return null;
    }

    String symbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public ClassName asClass() {
        return ClassName.fromString((String)this.symbol.substring(1, this.symbol.length() - 1));
    }

    public boolean isAnObject() {
        return this.symbol.startsWith("L");
    }

    private static Map<UnifiedType, UnifiedType> predicates() {
        HashMap<UnifiedType, UnifiedType> m = new HashMap<UnifiedType, UnifiedType>();
        m.put(INT, UnifiedType.object(IntPredicate.class));
        m.put(LONG, UnifiedType.object(LongPredicate.class));
        m.put(DOUBLE, UnifiedType.object(DoublePredicate.class));
        return m;
    }

    private static Map<UnifiedType, UnifiedType> streams() {
        HashMap<UnifiedType, UnifiedType> m = new HashMap<UnifiedType, UnifiedType>();
        m.put(INT, UnifiedType.object(IntStream.class));
        m.put(LONG, UnifiedType.object(LongStream.class));
        m.put(DOUBLE, UnifiedType.object(DoubleStream.class));
        return m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnifiedType type = (UnifiedType)o;
        return this.symbol.equals(type.symbol);
    }

    public int hashCode() {
        return Objects.hash(this.symbol);
    }
}

