/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators;

import com.groupcdg.arcmutate.mutators.MethodDesc;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.reloc.asm.Type;

public final class MethodLocation {
    private final ClassName clazz;
    private final String method;
    private final String methodDesc;

    public MethodLocation(ClassName clazz, String method, String methodDesc) {
        this.clazz = clazz;
        this.method = method;
        this.methodDesc = methodDesc;
    }

    public static MethodLocation location(Class<?> clazz, String method, MethodDesc methodDesc) {
        return MethodLocation.location(ClassName.fromClass(clazz), method, methodDesc.build());
    }

    public static MethodLocation location(ClassName clazz, String method, MethodDesc methodDesc) {
        return MethodLocation.location(clazz, method, methodDesc.build());
    }

    public static MethodLocation location(ClassName clazz, String method, String methodDesc) {
        return new MethodLocation(clazz, method, methodDesc);
    }

    public ClassName className() {
        return this.clazz;
    }

    public String methodName() {
        return this.method;
    }

    public String methodDesc() {
        return this.methodDesc;
    }

    public String describe() {
        return this.className().getNameWithoutPackage() + "." + this.methodName() + "(" + this.args() + ")";
    }

    public MethodLocation withMethod(String method) {
        return new MethodLocation(this.clazz, method, this.methodDesc);
    }

    public MethodLocation withClass(ClassName clazz) {
        return new MethodLocation(clazz, this.method, this.methodDesc);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.method, this.methodDesc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodLocation other = (MethodLocation)obj;
        return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.method, other.method) && Objects.equals(this.methodDesc, other.methodDesc);
    }

    private String args() {
        Type[] args = Type.getArgumentTypes((String)this.methodDesc);
        return IntStream.range(0, args.length).mapToObj(index -> this.toLetter(index, args[index])).collect(Collectors.joining(", "));
    }

    private String toLetter(int index, Type type) {
        return this.toLetter(type) + (index + 1);
    }

    private String toLetter(Type type) {
        switch (type.getSort()) {
            case 10: {
                return "o";
            }
            case 9: {
                return this.toLetter(type.getElementType()) + "[]";
            }
            case 1: {
                return "b";
            }
            case 2: {
                return "c";
            }
            case 8: {
                return "d";
            }
            case 6: {
                return "f";
            }
            case 5: {
                return "i";
            }
            case 4: {
                return "s";
            }
            case 7: {
                return "l";
            }
            case 3: {
                return "byte";
            }
        }
        return "o";
    }

    public Optional<MethodLocation> removeLastParam() {
        Type[] params = Type.getArgumentTypes((String)this.methodDesc);
        if (params.length == 0) {
            return Optional.empty();
        }
        Type[] reduced = Arrays.copyOf(params, params.length - 1);
        String newDescriptor = Type.getMethodDescriptor((Type)Type.getReturnType((String)this.methodDesc), (Type[])reduced);
        return Optional.of(new MethodLocation(this.clazz, this.method, newDescriptor));
    }

    public Location asLocation() {
        return Location.location((ClassName)this.clazz, (String)this.method, (String)this.methodDesc);
    }
}

