/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.internal;

import com.groupcdg.arcmutate.internal.ExtendedMutatorInterceptor;
import com.groupcdg.pitest.extended.licence.Licence;
import com.groupcdg.pitest.extended.licence.LicencePathFinder;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.util.Glob;

public class ExtendedMutatorsFactory
implements MutationInterceptorFactory {
    private final FileSystem fs;

    public ExtendedMutatorsFactory() {
        this(FileSystems.getDefault());
    }

    public ExtendedMutatorsFactory(FileSystem fs) {
        this.fs = fs;
    }

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        return new ExtendedMutatorInterceptor(this.checkLicence(interceptorParameters.data()));
    }

    public Feature provides() {
        return Feature.named((String)"EXTENDED").withOnByDefault(true).asInternalFeature().withDescription("Extended mutators");
    }

    public String description() {
        return "Extended mutators";
    }

    private Predicate<ClassName> checkLicence(ReportOptions data) {
        Licence licence = this.findLicence(data);
        return ExtendedMutatorsFactory.makeFilter(licence);
    }

    private Licence findLicence(ReportOptions data) {
        try {
            Path workingDir = this.fs.getPath("", new String[0]).toRealPath(new LinkOption[0]);
            Path reportDir = this.fs.getPath(data.getReportDir(), new String[0]).toRealPath(new LinkOption[0]);
            LicencePathFinder licenceFinder = new LicencePathFinder(workingDir);
            return Licence.findAndCheckLicence(Clock.systemUTC(), reportDir, data.getProjectBase(), licenceFinder, "EXTENSIONS");
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while looking for licence");
        }
    }

    private static Predicate<ClassName> makeFilter(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return c -> globs.stream().anyMatch(g -> g.test(c.asJavaName()));
    }
}

