/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.plugin;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

class ExclusionInterceptor
implements MutationInterceptor {
    private final Predicate<MutationDetails> mapFilter;
    private final Predicate<ClassName> licenceFilter;

    public ExclusionInterceptor(Predicate<MutationDetails> mapFilter, Predicate<ClassName> licenceFilter) {
        this.mapFilter = mapFilter;
        this.licenceFilter = licenceFilter;
    }

    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree classTree) {
        if (!this.licenceFilter.test(classTree.name())) {
            throw new IllegalStateException("Base plugin not licenced for package " + classTree.name().getPackage());
        }
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> collection, Mutater mutater) {
        return collection.stream().filter(this.mapFilter.negate()).collect(Collectors.toList());
    }

    public void end() {
    }
}

