/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.analysis;

import com.groupcdg.arcmutate.exclusions.analysis.Or;
import com.groupcdg.arcmutate.exclusions.analysis.TextExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.mutationtest.engine.MutationDetails;

public class ExclusionParser {
    private static int MAX_WALK_DEPTH = 3;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Predicate<MutationDetails> parseDirectory(Path start) {
        try (Stream<Path> paths = Files.walk(start, MAX_WALK_DEPTH, new FileVisitOption[0]);){
            List exclusions = paths.filter(f -> f.getFileName().toString().endsWith(".pitest")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::asInputStream).flatMap(i -> (Stream)ExclusionParser.parseInputStream(i).onClose(this.noThrowClose((InputStream)i))).map(l -> l.asExclusion()).collect(Collectors.toList());
            if (exclusions.isEmpty()) {
                Predicate<MutationDetails> predicate2 = m -> false;
                return predicate2;
            }
            Predicate<MutationDetails> predicate = Or.or(exclusions);
            return predicate;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Predicate<MutationDetails> parse(InputStream is) {
        return Or.or(ExclusionParser.parseRaw(is).map(l -> l.asExclusion()).collect(Collectors.toList()));
    }

    public static Stream<TextExclusion> parseRaw(InputStream is) {
        return ExclusionParser.parseInputStream(is);
    }

    private Runnable noThrowClose(InputStream in) {
        return () -> {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private InputStream asInputStream(Path p) {
        try {
            return Files.newInputStream(p, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<TextExclusion> parseInputStream(InputStream is) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        return r.lines().flatMap(ExclusionParser::toExclusion);
    }

    private static Stream<TextExclusion> toExclusion(String line) {
        if (line.trim().startsWith("#")) {
            return Stream.empty();
        }
        String[] parts = line.split(",");
        if (parts.length != 6) {
            throw new IllegalArgumentException("Invalid line " + line);
        }
        return Stream.of(new TextExclusion(parts[0], parts[1], parts[2], parts[3], ExclusionParser.parseIntOrElse(parts[4], 0), ExclusionParser.parseIntOrElse(parts[5], Integer.MAX_VALUE)));
    }

    private static int parseIntOrElse(String s, int orElse) {
        String trimmed = s.trim();
        if (trimmed.equals("*")) {
            return orElse;
        }
        try {
            return Integer.parseInt(trimmed);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expected " + s + " to be an integer or the '*' wildcard character.");
        }
    }
}

