package com.groobee.message.common;

import android.content.Context;
import android.util.Log;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.groobee.message.Groobee;
import com.groobee.message.utils.LoggerUtils;

import java.io.IOException;

public class GoogleAdvertising {

    private static final String TAG = LoggerUtils.getClassLogTag(GoogleAdvertising.class);

    private Context context = null;

    public GoogleAdvertising(Context context) {
        this.context = context;
    }

    public void getAdId() {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                String adId = "";
                try {
                    adId = AdvertisingIdClient.getAdvertisingIdInfo(context.getApplicationContext()).getId();
                    Groobee.getInstance().setAdvertisingId(adId);
                } catch (IllegalStateException ex) {
                    ex.printStackTrace();
                    Log.e(TAG,"IllegalStateException");
                } catch (GooglePlayServicesRepairableException ex) {
                    ex.printStackTrace();
                    Log.e(TAG,"GooglePlayServicesRepairableException");
                } catch (IOException ex) {
                    ex.printStackTrace();
                    Log.e(TAG,"IOException");
                } catch (GooglePlayServicesNotAvailableException ex) {
                    ex.printStackTrace();
                    Log.e(TAG,"GooglePlayServicesNotAvailableException");
                }
            }
        });

        thread.start();

        try { thread.join(); }
        catch (InterruptedException e) { e.printStackTrace(); }
    }
}
