/*
 * Decompiled with CFR 0.152.
 */
package com.greenpay.sdk.cipher;

import androidx.annotation.Keep;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.greenpay.sdk.cipher.aesctr.models.AESCounter;
import com.greenpay.sdk.cipher.aesctr.models.AESKey;
import com.greenpay.sdk.cipher.aesctr.models.AESPair;
import com.greenpay.sdk.cipher.aesctr.utils.AESCRTUtils;
import com.greenpay.sdk.cipher.exceptions.GException;
import com.greenpay.sdk.cipher.models.CipherResult;
import com.greenpay.sdk.cipher.utils.Logger;
import com.greenpay.sdk.cipher.utils.ResponseCallback;
import com.greenpay.sdk.cipher.utils.StringUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GCipher {
    private static final String TAG = GCipher.class.getSimpleName();
    private static volatile GCipher instance = null;
    private String publicKey = null;

    private void checkConfigs() throws GException {
        if (this.publicKey == null || this.publicKey.isEmpty()) {
            throw new GException("Public key not set.");
        }
        if (!StringUtils.validatePublicKey(this.publicKey).booleanValue()) {
            throw new GException("Invalid public key format.");
        }
    }

    private GCipher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    public static GCipher getInstance() {
        if (instance != null) return instance;
        Class<GCipher> clazz = GCipher.class;
        synchronized (GCipher.class) {
            if (instance != null) return instance;
            instance = new GCipher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Keep
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Keep
    public void enableLogs() {
        Logger.enableLogs();
    }

    @Keep
    public void cipher(String data, ResponseCallback<CipherResult> responseCallback) {
        try {
            this.checkConfigs();
            AESKey aesKey = AESCRTUtils.generateAESKey();
            byte[] keyBytes = aesKey.getKeyValue();
            AESCounter aesCounter = AESCRTUtils.generateAESCounter();
            byte[] counterBytes = aesCounter.getCounterValue();
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            byte[] dataBytes = data.getBytes();
            byte[] aesValue = AESCRTUtils.cipherWithAESCTR(dataBytes, keyBytes, counterBytes);
            String aesHexValue = StringUtils.byteArrayToHexString(aesValue);
            AESPair aesPair = new AESPair();
            aesPair.setKey(aesKey.getKey());
            aesPair.setCounter(aesCounter.getCounter());
            String aesPairStr = gson.toJson((Object)aesPair);
            String lk = AESCRTUtils.cipherWithPublicKey(aesPairStr, this.publicKey);
            CipherResult result = new CipherResult(aesHexValue, lk);
            responseCallback.onSuccess(result);
        }
        catch (NoSuchPaddingException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (InvalidKeyException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (BadPaddingException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (GException e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage());
            responseCallback.onError(e.getMessage());
        }
    }
}

