package com.greenpay.sdk.cipher.aesctr.utils;

import android.util.Base64;

import com.greenpay.sdk.cipher.aesctr.models.AESCounter;
import com.greenpay.sdk.cipher.aesctr.models.AESKey;
import com.greenpay.sdk.cipher.exceptions.GException;
import com.greenpay.sdk.cipher.utils.Logger;
import com.greenpay.sdk.cipher.utils.StringConstants;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCRTUtils {

    private static final String TAG = AESCRTUtils.class.getSimpleName();

    public static AESKey generateAESKey(){
        int[] key = new int[16];
        Random random = new Random();
        for(int i=0; i< 16; ++i){
            int randomNumber = random.nextInt(256);
            key[i] = randomNumber;
        }
        AESKey aesKey = new AESKey(key);
        return aesKey;
    }

    public static AESCounter generateAESCounter() {
        // Un valor entre 0 y 255.
        AESCounter aesCounter = new AESCounter(new Random().nextInt(256));
        return aesCounter;
    }

    public static byte[] cipherWithAESCTR(byte[] plainTextAsByteArray, byte[] key, byte[] counter) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(AESCRTConstants.CIPHER_ALGORITHM);
        SecretKey originalKey = new SecretKeySpec(key, 0, key.length, AESCRTConstants.KEY_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, originalKey, new IvParameterSpec(counter));
        byte[] cipheredValue = cipher.doFinal(plainTextAsByteArray);
        return cipheredValue;
    }

    public static String cipherWithPublicKey(String textToCipher, String publicKeyContent) throws NoSuchAlgorithmException,
            NoSuchPaddingException,
            InvalidKeyException,
            IllegalBlockSizeException,
            BadPaddingException, GException {

        PublicKey rsaPublicKey = stringToPublicKey(publicKeyContent);
        if(rsaPublicKey == null) {
            throw new GException("Invalid public key format.");
        }
        Cipher cipher = Cipher.getInstance(AESCRTConstants.PUBLIC_KEY_CIPHER_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, rsaPublicKey);
        byte[] encryptedBytes = cipher.doFinal(textToCipher.getBytes());
        return Base64.encodeToString(encryptedBytes, Base64.NO_WRAP);
    }

    public static PublicKey stringToPublicKey (String publicKeyString) {
        try {
            if (publicKeyString.contains(StringConstants.BEGIN_PUBLIC_KEY) || publicKeyString.contains(StringConstants.END_PUBLIC_KEY))
                publicKeyString = publicKeyString.replace(StringConstants.BEGIN_PUBLIC_KEY, StringConstants.EMPTY_STRING).replace(StringConstants.END_PUBLIC_KEY, StringConstants.EMPTY_STRING);
            byte[] keyBytes = Base64.decode(publicKeyString, Base64.DEFAULT);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(AESCRTConstants.PUBLIC_KEY_ALGORITHM);
            return keyFactory.generatePublic(spec);
        } catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Logger.e(TAG, e.getMessage());
            return null;
        }
    }
}
