/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import android.os.SystemClock;
import com.greedygame.network.Request;
import com.greedygame.network.Response;
import com.greedygame.network.VolleyError;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFuture<T>
implements Future<T>,
Response.Listener<T>,
Response.ErrorListener {
    private Request<?> mRequest;
    private boolean mResultReceived = false;
    private T mResult;
    private VolleyError mException;

    public static <E> RequestFuture<E> newFuture() {
        return new RequestFuture();
    }

    private RequestFuture() {
    }

    public void setRequest(Request<?> request) {
        this.mRequest = request;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.mRequest == null) {
            return false;
        }
        if (!this.isDone()) {
            this.mRequest.cancel();
            return true;
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    private synchronized T doGet(Long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (this.mResultReceived) {
            return this.mResult;
        }
        if (timeoutMs == null) {
            while (!this.isDone()) {
                this.wait(0L);
            }
        } else if (timeoutMs > 0L) {
            long nowMs = SystemClock.uptimeMillis();
            long deadlineMs = nowMs + timeoutMs;
            while (!this.isDone() && nowMs < deadlineMs) {
                this.wait(deadlineMs - nowMs);
                nowMs = SystemClock.uptimeMillis();
            }
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (!this.mResultReceived) {
            throw new TimeoutException();
        }
        return this.mResult;
    }

    @Override
    public boolean isCancelled() {
        if (this.mRequest == null) {
            return false;
        }
        return this.mRequest.isCanceled();
    }

    @Override
    public synchronized boolean isDone() {
        return this.mResultReceived || this.mException != null || this.isCancelled();
    }

    @Override
    public synchronized void onResponse(T response) {
        this.mResultReceived = true;
        this.mResult = response;
        this.notifyAll();
    }

    @Override
    public synchronized void onErrorResponse(VolleyError error) {
        this.mException = error;
        this.notifyAll();
    }
}

