/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import androidx.annotation.VisibleForTesting;
import com.greedygame.network.AuthFailureError;
import com.greedygame.network.Header;
import com.greedygame.network.Request;
import com.greedygame.network.toolbox.BaseHttpStack;
import com.greedygame.network.toolbox.HttpResponse;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HurlStack
extends BaseHttpStack {
    private static final int HTTP_CONTINUE = 100;
    private final UrlRewriter mUrlRewriter;
    private final SSLSocketFactory mSslSocketFactory;

    public HurlStack() {
        this(null);
    }

    public HurlStack(UrlRewriter urlRewriter) {
        this(urlRewriter, null);
    }

    public HurlStack(UrlRewriter urlRewriter, SSLSocketFactory sslSocketFactory) {
        this.mUrlRewriter = urlRewriter;
        this.mSslSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse executeRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        String url = request.getUrl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(additionalHeaders);
        map.putAll(request.getHeaders());
        if (this.mUrlRewriter != null) {
            String rewritten = this.mUrlRewriter.rewriteUrl(url);
            if (rewritten == null) {
                throw new IOException("URL blocked by rewriter: " + url);
            }
            url = rewritten;
        }
        URL parsedUrl = new URL(url);
        HttpURLConnection connection = this.openConnection(parsedUrl, request);
        boolean keepConnectionOpen = false;
        try {
            HttpResponse httpResponse;
            for (String headerName : map.keySet()) {
                connection.setRequestProperty(headerName, (String)map.get(headerName));
            }
            HurlStack.setConnectionParametersForRequest(connection, request);
            int responseCode = connection.getResponseCode();
            if (responseCode == -1) {
                throw new IOException("Could not retrieve response code from HttpUrlConnection.");
            }
            if (!HurlStack.hasResponseBody(request.getMethod(), responseCode)) {
                httpResponse = new HttpResponse(responseCode, HurlStack.convertHeaders(connection.getHeaderFields()));
                return httpResponse;
            }
            keepConnectionOpen = true;
            httpResponse = new HttpResponse(responseCode, HurlStack.convertHeaders(connection.getHeaderFields()), connection.getContentLength(), new UrlConnectionInputStream(connection));
            return httpResponse;
        }
        finally {
            if (!keepConnectionOpen) {
                connection.disconnect();
            }
        }
    }

    @VisibleForTesting
    static List<Header> convertHeaders(Map<String, List<String>> responseHeaders) {
        ArrayList<Header> headerList = new ArrayList<Header>(responseHeaders.size());
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            if (entry.getKey() == null) continue;
            for (String value : entry.getValue()) {
                headerList.add(new Header(entry.getKey(), value));
            }
        }
        return headerList;
    }

    private static boolean hasResponseBody(int requestMethod, int responseCode) {
        return requestMethod != 4 && (100 > responseCode || responseCode >= 200) && responseCode != 204 && responseCode != 304;
    }

    private static InputStream inputStreamFromConnection(HttpURLConnection connection) {
        InputStream inputStream;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException ioe) {
            inputStream = connection.getErrorStream();
        }
        return inputStream;
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return connection;
    }

    private HttpURLConnection openConnection(URL url, Request<?> request) throws IOException {
        HttpURLConnection connection = this.createConnection(url);
        int timeoutMs = request.getTimeoutMs();
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if ("https".equals(url.getProtocol()) && this.mSslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.mSslSocketFactory);
        }
        return connection;
    }

    static void setConnectionParametersForRequest(HttpURLConnection connection, Request<?> request) throws IOException, AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody == null) break;
                connection.setRequestMethod("POST");
                HurlStack.addBody(connection, request, postBody);
                break;
            }
            case 0: {
                connection.setRequestMethod("GET");
                break;
            }
            case 3: {
                connection.setRequestMethod("DELETE");
                break;
            }
            case 1: {
                connection.setRequestMethod("POST");
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            case 2: {
                connection.setRequestMethod("PUT");
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            case 4: {
                connection.setRequestMethod("HEAD");
                break;
            }
            case 5: {
                connection.setRequestMethod("OPTIONS");
                break;
            }
            case 6: {
                connection.setRequestMethod("TRACE");
                break;
            }
            case 7: {
                connection.setRequestMethod("PATCH");
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static void addBodyIfExists(HttpURLConnection connection, Request<?> request) throws IOException, AuthFailureError {
        byte[] body = request.getBody();
        if (body != null) {
            HurlStack.addBody(connection, request, body);
        }
    }

    private static void addBody(HttpURLConnection connection, Request<?> request, byte[] body) throws IOException {
        connection.setDoOutput(true);
        if (!connection.getRequestProperties().containsKey("Content-Type")) {
            connection.setRequestProperty("Content-Type", request.getBodyContentType());
        }
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.write(body);
        out.close();
    }

    static class UrlConnectionInputStream
    extends FilterInputStream {
        private final HttpURLConnection mConnection;

        UrlConnectionInputStream(HttpURLConnection connection) {
            super(HurlStack.inputStreamFromConnection(connection));
            this.mConnection = connection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.mConnection.disconnect();
        }
    }

    public static interface UrlRewriter {
        public String rewriteUrl(String var1);
    }
}

