/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import com.greedygame.network.Cache;
import com.greedygame.network.Header;
import com.greedygame.network.NetworkResponse;
import com.greedygame.network.VolleyLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class HttpHeaderParser {
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final String RFC1123_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public static Cache.Entry parseCacheHeaders(NetworkResponse response) {
        long now = System.currentTimeMillis();
        Map<String, String> headers = response.headers;
        long serverDate = 0L;
        long lastModified = 0L;
        long serverExpires = 0L;
        long softExpire = 0L;
        long finalExpire = 0L;
        long maxAge = 0L;
        long staleWhileRevalidate = 0L;
        boolean hasCacheControl = false;
        boolean mustRevalidate = false;
        String serverEtag = null;
        String headerValue = headers.get("Date");
        if (headerValue != null) {
            serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        if ((headerValue = headers.get("Cache-Control")) != null) {
            hasCacheControl = true;
            String[] tokens = headerValue.split(",", 0);
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (token.equals("no-cache") || token.equals("no-store")) {
                    return null;
                }
                if (token.startsWith("max-age=")) {
                    try {
                        maxAge = Long.parseLong(token.substring(8));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (token.startsWith("stale-while-revalidate=")) {
                    try {
                        staleWhileRevalidate = Long.parseLong(token.substring(23));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!token.equals("must-revalidate") && !token.equals("proxy-revalidate")) continue;
                mustRevalidate = true;
            }
        }
        if ((headerValue = headers.get("Expires")) != null) {
            serverExpires = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        if ((headerValue = headers.get("Last-Modified")) != null) {
            lastModified = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        serverEtag = headers.get("ETag");
        if (hasCacheControl) {
            softExpire = now + maxAge * 1000L;
            finalExpire = mustRevalidate ? softExpire : softExpire + staleWhileRevalidate * 1000L;
        } else if (serverDate > 0L && serverExpires >= serverDate) {
            finalExpire = softExpire = now + (serverExpires - serverDate);
        }
        Cache.Entry entry = new Cache.Entry();
        entry.data = response.data;
        entry.etag = serverEtag;
        entry.softTtl = softExpire;
        entry.ttl = finalExpire;
        entry.serverDate = serverDate;
        entry.lastModified = lastModified;
        entry.responseHeaders = headers;
        entry.allResponseHeaders = response.allHeaders;
        return entry;
    }

    public static long parseDateAsEpoch(String dateStr) {
        try {
            return HttpHeaderParser.newRfc1123Formatter().parse(dateStr).getTime();
        }
        catch (ParseException e) {
            VolleyLog.e(e, "Unable to parse dateStr: %s, falling back to 0", dateStr);
            return 0L;
        }
    }

    static String formatEpochAsRfc1123(long epoch) {
        return HttpHeaderParser.newRfc1123Formatter().format(new Date(epoch));
    }

    private static SimpleDateFormat newRfc1123Formatter() {
        SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_FORMAT, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }

    public static String parseCharset(Map<String, String> headers, String defaultCharset) {
        String contentType = headers.get(HEADER_CONTENT_TYPE);
        if (contentType != null) {
            String[] params = contentType.split(";", 0);
            for (int i = 1; i < params.length; ++i) {
                String[] pair = params[i].trim().split("=", 0);
                if (pair.length != 2 || !pair[0].equals("charset")) continue;
                return pair[1];
            }
        }
        return defaultCharset;
    }

    public static String parseCharset(Map<String, String> headers) {
        return HttpHeaderParser.parseCharset(headers, DEFAULT_CONTENT_CHARSET);
    }

    static Map<String, String> toHeaderMap(List<Header> allHeaders) {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : allHeaders) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    static List<Header> toAllHeaderList(Map<String, String> headers) {
        ArrayList<Header> allHeaders = new ArrayList<Header>(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            allHeaders.add(new Header(header.getKey(), header.getValue()));
        }
        return allHeaders;
    }
}

