/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import android.os.SystemClock;
import com.greedygame.network.AuthFailureError;
import com.greedygame.network.Cache;
import com.greedygame.network.ClientError;
import com.greedygame.network.Header;
import com.greedygame.network.Network;
import com.greedygame.network.NetworkError;
import com.greedygame.network.NetworkResponse;
import com.greedygame.network.NoConnectionError;
import com.greedygame.network.Request;
import com.greedygame.network.RetryPolicy;
import com.greedygame.network.ServerError;
import com.greedygame.network.TimeoutError;
import com.greedygame.network.VolleyError;
import com.greedygame.network.VolleyLog;
import com.greedygame.network.toolbox.AdaptedHttpStack;
import com.greedygame.network.toolbox.BaseHttpStack;
import com.greedygame.network.toolbox.ByteArrayPool;
import com.greedygame.network.toolbox.HttpHeaderParser;
import com.greedygame.network.toolbox.HttpResponse;
import com.greedygame.network.toolbox.HttpStack;
import com.greedygame.network.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class BasicNetwork
implements Network {
    protected static final boolean DEBUG = VolleyLog.DEBUG;
    private static final int SLOW_REQUEST_THRESHOLD_MS = 3000;
    private static final int DEFAULT_POOL_SIZE = 4096;
    @Deprecated
    protected final HttpStack mHttpStack;
    private final BaseHttpStack mBaseHttpStack;
    protected final ByteArrayPool mPool;

    @Deprecated
    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(4096));
    }

    @Deprecated
    public BasicNetwork(HttpStack httpStack, ByteArrayPool pool) {
        this.mHttpStack = httpStack;
        this.mBaseHttpStack = new AdaptedHttpStack(httpStack);
        this.mPool = pool;
    }

    public BasicNetwork(BaseHttpStack httpStack) {
        this(httpStack, new ByteArrayPool(4096));
    }

    public BasicNetwork(BaseHttpStack httpStack, ByteArrayPool pool) {
        this.mBaseHttpStack = httpStack;
        this.mHttpStack = httpStack;
        this.mPool = pool;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws VolleyError {
        long requestStart = SystemClock.elapsedRealtime();
        while (true) {
            int statusCode;
            HttpResponse httpResponse = null;
            byte[] responseContents = null;
            List<Header> responseHeaders = Collections.emptyList();
            try {
                Map<String, String> additionalRequestHeaders = this.getCacheHeaders(request.getCacheEntry());
                httpResponse = this.mBaseHttpStack.executeRequest(request, additionalRequestHeaders);
                statusCode = httpResponse.getStatusCode();
                responseHeaders = httpResponse.getHeaders();
                if (statusCode == 304) {
                    Cache.Entry entry = request.getCacheEntry();
                    if (entry == null) {
                        return new NetworkResponse(304, null, true, SystemClock.elapsedRealtime() - requestStart, responseHeaders);
                    }
                    List<Header> combinedHeaders = BasicNetwork.combineHeaders(responseHeaders, entry);
                    return new NetworkResponse(304, entry.data, true, SystemClock.elapsedRealtime() - requestStart, combinedHeaders);
                }
                InputStream inputStream = httpResponse.getContent();
                responseContents = inputStream != null ? this.inputStreamToBytes(inputStream, httpResponse.getContentLength()) : new byte[]{};
                long requestLifetime = SystemClock.elapsedRealtime() - requestStart;
                this.logSlowRequests(requestLifetime, request, responseContents, statusCode);
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException();
                }
                return new NetworkResponse(statusCode, responseContents, false, SystemClock.elapsedRealtime() - requestStart, responseHeaders);
            }
            catch (SocketTimeoutException e) {
                BasicNetwork.attemptRetryOnException("socket", request, new TimeoutError());
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Bad URL " + request.getUrl(), e);
            }
            catch (IOException e) {
                if (httpResponse == null) {
                    throw new NoConnectionError(e);
                }
                statusCode = httpResponse.getStatusCode();
                VolleyLog.e("Unexpected response code %d for %s", statusCode, request.getUrl());
                if (responseContents != null) {
                    NetworkResponse networkResponse = new NetworkResponse(statusCode, responseContents, false, SystemClock.elapsedRealtime() - requestStart, responseHeaders);
                    if (statusCode == 401 || statusCode == 403) {
                        BasicNetwork.attemptRetryOnException("auth", request, new AuthFailureError(networkResponse));
                        continue;
                    }
                    if (statusCode >= 400 && statusCode <= 499) {
                        throw new ClientError(networkResponse);
                    }
                    if (statusCode >= 500 && statusCode <= 599) {
                        if (request.shouldRetryServerErrors()) {
                            BasicNetwork.attemptRetryOnException("server", request, new ServerError(networkResponse));
                            continue;
                        }
                        throw new ServerError(networkResponse);
                    }
                    throw new ServerError(networkResponse);
                }
                BasicNetwork.attemptRetryOnException("network", request, new NetworkError());
                continue;
            }
            break;
        }
    }

    private void logSlowRequests(long requestLifetime, Request<?> request, byte[] responseContents, int statusCode) {
        if (DEBUG || requestLifetime > 3000L) {
            VolleyLog.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", request, requestLifetime, responseContents != null ? Integer.valueOf(responseContents.length) : "null", statusCode, request.getRetryPolicy().getCurrentRetryCount());
        }
    }

    private static void attemptRetryOnException(String logPrefix, Request<?> request, VolleyError exception) throws VolleyError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int oldTimeout = request.getTimeoutMs();
        try {
            retryPolicy.retry(exception);
        }
        catch (VolleyError e) {
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", logPrefix, oldTimeout));
            throw e;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", logPrefix, oldTimeout));
    }

    private Map<String, String> getCacheHeaders(Cache.Entry entry) {
        if (entry == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (entry.etag != null) {
            headers.put("If-None-Match", entry.etag);
        }
        if (entry.lastModified > 0L) {
            headers.put("If-Modified-Since", HttpHeaderParser.formatEpochAsRfc1123(entry.lastModified));
        }
        return headers;
    }

    protected void logError(String what, String url, long start) {
        long now = SystemClock.elapsedRealtime();
        VolleyLog.v("HTTP ERROR(%s) %d ms to fetch %s", what, now - start, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] inputStreamToBytes(InputStream in, int contentLength) throws IOException, ServerError {
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(this.mPool, contentLength);
        byte[] buffer = null;
        try {
            int count;
            if (in == null) {
                throw new ServerError();
            }
            buffer = this.mPool.getBuf(1024);
            while ((count = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                VolleyLog.v("Error occurred when closing InputStream", new Object[0]);
            }
            this.mPool.returnBuf(buffer);
            bytes.close();
        }
    }

    @Deprecated
    protected static Map<String, String> convertHeaders(Header[] headers) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < headers.length; ++i) {
            result.put(headers[i].getName(), headers[i].getValue());
        }
        return result;
    }

    private static List<Header> combineHeaders(List<Header> responseHeaders, Cache.Entry entry) {
        ArrayList<Header> combinedHeaders;
        block6: {
            TreeSet<String> headerNamesFromNetworkResponse;
            block5: {
                headerNamesFromNetworkResponse = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (!responseHeaders.isEmpty()) {
                    for (Header header : responseHeaders) {
                        headerNamesFromNetworkResponse.add(header.getName());
                    }
                }
                combinedHeaders = new ArrayList<Header>(responseHeaders);
                if (entry.allResponseHeaders == null) break block5;
                if (entry.allResponseHeaders.isEmpty()) break block6;
                for (Header header : entry.allResponseHeaders) {
                    if (headerNamesFromNetworkResponse.contains(header.getName())) continue;
                    combinedHeaders.add(header);
                }
                break block6;
            }
            if (!entry.responseHeaders.isEmpty()) {
                for (Map.Entry entry2 : entry.responseHeaders.entrySet()) {
                    if (headerNamesFromNetworkResponse.contains(entry2.getKey())) continue;
                    combinedHeaders.add(new Header((String)entry2.getKey(), (String)entry2.getValue()));
                }
            }
        }
        return combinedHeaders;
    }
}

