/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import com.greedygame.network.AuthFailureError;
import com.greedygame.network.Header;
import com.greedygame.network.Request;
import com.greedygame.network.toolbox.BaseHttpStack;
import com.greedygame.network.toolbox.HttpResponse;
import com.greedygame.network.toolbox.HttpStack;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;

class AdaptedHttpStack
extends BaseHttpStack {
    private final HttpStack mHttpStack;

    AdaptedHttpStack(HttpStack httpStack) {
        this.mHttpStack = httpStack;
    }

    @Override
    public HttpResponse executeRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        org.apache.http.HttpResponse apacheResp;
        try {
            apacheResp = this.mHttpStack.performRequest(request, additionalHeaders);
        }
        catch (ConnectTimeoutException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
        int statusCode = apacheResp.getStatusLine().getStatusCode();
        org.apache.http.Header[] headers = apacheResp.getAllHeaders();
        ArrayList<Header> headerList = new ArrayList<Header>(headers.length);
        for (org.apache.http.Header header : headers) {
            headerList.add(new Header(header.getName(), header.getValue()));
        }
        if (apacheResp.getEntity() == null) {
            return new HttpResponse(statusCode, headerList);
        }
        long contentLength = apacheResp.getEntity().getContentLength();
        if ((long)((int)contentLength) != contentLength) {
            throw new IOException("Response too large: " + contentLength);
        }
        return new HttpResponse(statusCode, headerList, (int)apacheResp.getEntity().getContentLength(), apacheResp.getEntity().getContent());
    }
}

